/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.curiosities.toolbox.ToolboxBlock;
import com.simibubi.create.content.curiosities.toolbox.ToolboxContainer;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandler;
import com.simibubi.create.content.curiosities.toolbox.ToolboxInventory;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ToolboxTileEntity
extends SmartTileEntity
implements INamedContainerProvider,
INameable {
    public LerpedFloat lid = LerpedFloat.linear().startWithValue(0.0);
    public LerpedFloat drawers = LerpedFloat.linear().startWithValue(0.0);
    ToolboxInventory inventory;
    LazyOptional<IItemHandler> inventoryProvider;
    LazyOptional<DyeColor> colorProvider;
    protected int openCount;
    Map<Integer, WeakHashMap<PlayerEntity, Integer>> connectedPlayers = new HashMap<Integer, WeakHashMap<PlayerEntity, Integer>>();
    private ITextComponent customName;

    public ToolboxTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.inventory = new ToolboxInventory(this);
        this.inventoryProvider = LazyOptional.of(() -> this.inventory);
        this.colorProvider = LazyOptional.of(() -> {
            BlockState blockState = this.func_195044_w();
            if (blockState != null && blockState.func_177230_c() instanceof ToolboxBlock) {
                return ((ToolboxBlock)blockState.func_177230_c()).getColor();
            }
            return DyeColor.BROWN;
        });
        this.setLazyTickRate(10);
    }

    public DyeColor getColor() {
        return (DyeColor)this.colorProvider.orElse((Object)DyeColor.BROWN);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void initialize() {
        super.initialize();
        ToolboxHandler.onLoad(this);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        ToolboxHandler.onUnload(this);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.tickAudio();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.tickPlayers();
        }
        this.lid.chase(this.openCount > 0 ? 1.0 : 0.0, 0.2f, LerpedFloat.Chaser.LINEAR);
        this.drawers.chase(this.openCount > 0 ? 1.0 : 0.0, 0.2f, LerpedFloat.Chaser.EXP);
        this.lid.tickChaser();
        this.drawers.tickChaser();
    }

    private void tickPlayers() {
        boolean update = false;
        Iterator<Map.Entry<Integer, WeakHashMap<PlayerEntity, Integer>>> toolboxSlots = this.connectedPlayers.entrySet().iterator();
        while (toolboxSlots.hasNext()) {
            Map.Entry<Integer, WeakHashMap<PlayerEntity, Integer>> toolboxSlotEntry = toolboxSlots.next();
            WeakHashMap<PlayerEntity, Integer> set = toolboxSlotEntry.getValue();
            int slot = toolboxSlotEntry.getKey();
            ItemStack referenceItem = this.inventory.filters.get(slot);
            boolean clear = referenceItem.func_190926_b();
            Iterator<Map.Entry<PlayerEntity, Integer>> playerEntries = set.entrySet().iterator();
            while (playerEntries.hasNext()) {
                int deposited;
                int targetAmount;
                Map.Entry<PlayerEntity, Integer> playerEntry = playerEntries.next();
                PlayerEntity player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();
                if (!clear && !ToolboxHandler.withinRange(player, this)) continue;
                ItemStack playerStack = player.field_71071_by.func_70301_a(hotbarSlot);
                if (clear || !playerStack.func_190926_b() && !ToolboxInventory.canItemsShareCompartment(playerStack, referenceItem)) {
                    player.getPersistentData().func_74775_l("CreateToolboxData").func_82580_o(String.valueOf(hotbarSlot));
                    playerEntries.remove();
                    if (!(player instanceof ServerPlayerEntity)) continue;
                    ToolboxHandler.syncData(player);
                    continue;
                }
                int count = playerStack.func_190916_E();
                if (count < (targetAmount = (referenceItem.func_77976_d() + 1) / 2)) {
                    ItemStack extracted;
                    int amountToReplenish = targetAmount - count;
                    if (this.isOpenInContainer(player) && !(extracted = this.inventory.takeFromCompartment(amountToReplenish, slot, true)).func_190926_b()) {
                        ToolboxHandler.unequip(player, hotbarSlot, false);
                        ToolboxHandler.syncData(player);
                        continue;
                    }
                    extracted = this.inventory.takeFromCompartment(amountToReplenish, slot, false);
                    if (!extracted.func_190926_b()) {
                        update = true;
                        ItemStack template = playerStack.func_190926_b() ? extracted : playerStack;
                        player.field_71071_by.func_70299_a(hotbarSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)template, (int)(count + extracted.func_190916_E())));
                    }
                }
                if (count <= targetAmount) continue;
                int amountToDeposit = count - targetAmount;
                ItemStack toDistribute = ItemHandlerHelper.copyStackWithSize((ItemStack)playerStack, (int)amountToDeposit);
                if (this.isOpenInContainer(player) && (deposited = amountToDeposit - this.inventory.distributeToCompartment(toDistribute, slot, true).func_190916_E()) > 0) {
                    ToolboxHandler.unequip(player, hotbarSlot, true);
                    ToolboxHandler.syncData(player);
                    continue;
                }
                deposited = amountToDeposit - this.inventory.distributeToCompartment(toDistribute, slot, false).func_190916_E();
                if (deposited <= 0) continue;
                update = true;
                player.field_71071_by.func_70299_a(hotbarSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)playerStack, (int)(count - deposited)));
            }
            if (!clear) continue;
            toolboxSlots.remove();
        }
        if (update) {
            this.sendData();
        }
    }

    private boolean isOpenInContainer(PlayerEntity player) {
        return player.field_71070_bA instanceof ToolboxContainer && ((ToolboxContainer)player.field_71070_bA).contentHolder == this;
    }

    public void unequipTracked() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        HashSet<ServerPlayerEntity> affected = new HashSet<ServerPlayerEntity>();
        for (Map.Entry<Integer, WeakHashMap<PlayerEntity, Integer>> toolboxSlotEntry : this.connectedPlayers.entrySet()) {
            WeakHashMap<PlayerEntity, Integer> set = toolboxSlotEntry.getValue();
            for (Map.Entry<PlayerEntity, Integer> playerEntry : set.entrySet()) {
                PlayerEntity player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();
                ToolboxHandler.unequip(player, hotbarSlot, false);
                if (!(player instanceof ServerPlayerEntity)) continue;
                affected.add((ServerPlayerEntity)player);
            }
        }
        for (ServerPlayerEntity player : affected) {
            ToolboxHandler.syncData((PlayerEntity)player);
        }
        this.connectedPlayers.clear();
    }

    public void unequip(int slot, PlayerEntity player, int hotbarSlot, boolean keepItems) {
        if (!this.connectedPlayers.containsKey(slot)) {
            return;
        }
        this.connectedPlayers.get(slot).remove(player);
        if (keepItems) {
            return;
        }
        ItemStack playerStack = player.field_71071_by.func_70301_a(hotbarSlot);
        ItemStack toInsert = ToolboxInventory.cleanItemNBT(playerStack.func_77946_l());
        ItemStack remainder = this.inventory.distributeToCompartment(toInsert, slot, false);
        if (remainder.func_190916_E() != toInsert.func_190916_E()) {
            player.field_71071_by.func_70299_a(hotbarSlot, remainder);
        }
    }

    private void tickAudio() {
        Vector3d vec = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
        if (this.lid.settled()) {
            if (this.openCount > 0 && this.lid.getChaseTarget() == 0.0f) {
                this.field_145850_b.func_184134_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, SoundEvents.field_187611_cI, SoundCategory.BLOCKS, 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 1.2f, true);
                this.field_145850_b.func_184134_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.1f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 1.1f, true);
            }
            if (this.openCount == 0 && this.lid.getChaseTarget() == 1.0f) {
                this.field_145850_b.func_184134_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.1f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 1.1f, true);
            }
        } else if (this.openCount == 0 && this.lid.getChaseTarget() == 0.0f && this.lid.getValue(0.0f) > 0.0625f && this.lid.getValue(1.0f) < 0.0625f) {
            this.field_145850_b.func_184134_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, SoundEvents.field_187608_cH, SoundCategory.BLOCKS, 0.25f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 1.2f, true);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.inventoryProvider.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        super.fromTag(state, compound, clientPacket);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        if (clientPacket) {
            this.openCount = compound.func_74762_e("OpenCount");
        }
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        super.write(compound, clientPacket);
        if (clientPacket) {
            compound.func_74768_a("OpenCount", this.openCount);
        }
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return ToolboxContainer.create(id, inv, this);
    }

    @Override
    public void lazyTick() {
        this.updateOpenCount();
        ToolboxHandler.onLoad(this);
        super.lazyTick();
    }

    void updateOpenCount() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.openCount == 0) {
            return;
        }
        int prevOpenCount = this.openCount;
        this.openCount = 0;
        for (PlayerEntity playerentity : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(8.0))) {
            if (!(playerentity.field_71070_bA instanceof ToolboxContainer) || ((ToolboxContainer)playerentity.field_71070_bA).contentHolder != this) continue;
            ++this.openCount;
        }
        if (prevOpenCount != this.openCount) {
            this.sendData();
        }
    }

    public void startOpen(PlayerEntity player) {
        if (player.func_175149_v()) {
            return;
        }
        if (this.openCount < 0) {
            this.openCount = 0;
        }
        ++this.openCount;
        this.sendData();
    }

    public void stopOpen(PlayerEntity player) {
        if (player.func_175149_v()) {
            return;
        }
        --this.openCount;
        this.sendData();
    }

    public void connectPlayer(int slot, PlayerEntity player, int hotbarSlot) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        WeakHashMap map = this.connectedPlayers.computeIfAbsent(slot, WeakHashMap::new);
        Integer previous = (Integer)map.get(player);
        if (previous != null) {
            if (previous == hotbarSlot) {
                return;
            }
            ToolboxHandler.unequip(player, previous, false);
        }
        map.put(player, hotbarSlot);
    }

    public void readInventory(CompoundNBT compound) {
        this.inventory.deserializeNBT(compound);
    }

    public void setCustomName(ITextComponent customName) {
        this.customName = customName;
    }

    public ITextComponent func_145748_c_() {
        return this.customName != null ? this.customName : new TranslationTextComponent(((ToolboxBlock)AllBlocks.TOOLBOXES.get(this.getColor()).get()).func_149739_a());
    }

    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    public ITextComponent func_200200_C_() {
        return this.customName;
    }
}

