/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public abstract class ShootableGadgetRenderHandler {
    protected float leftHandAnimation;
    protected float rightHandAnimation;
    protected float lastLeftHandAnimation;
    protected float lastRightHandAnimation;
    protected boolean dontReequipLeft;
    protected boolean dontReequipRight;

    public void tick() {
        this.lastLeftHandAnimation = this.leftHandAnimation;
        this.lastRightHandAnimation = this.rightHandAnimation;
        this.leftHandAnimation *= this.animationDecay();
        this.rightHandAnimation *= this.animationDecay();
    }

    public float getAnimation(boolean rightHand, float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)(rightHand ? this.lastRightHandAnimation : this.lastLeftHandAnimation), (float)(rightHand ? this.rightHandAnimation : this.leftHandAnimation));
    }

    protected float animationDecay() {
        return 0.8f;
    }

    public void shoot(Hand hand, Vector3d location) {
        ClientPlayerEntity player;
        boolean rightHand = hand == Hand.MAIN_HAND ^ (player = Minecraft.func_71410_x().field_71439_g).func_184591_cq() == HandSide.LEFT;
        if (rightHand) {
            this.rightHandAnimation = 0.2f;
            this.dontReequipRight = false;
        } else {
            this.leftHandAnimation = 0.2f;
            this.dontReequipLeft = false;
        }
        this.playSound(hand, location);
    }

    protected abstract void playSound(Hand var1, Vector3d var2);

    protected abstract boolean appliesTo(ItemStack var1);

    protected abstract void transformTool(MatrixStack var1, float var2, float var3, float var4, float var5);

    protected abstract void transformHand(MatrixStack var1, float var2, float var3, float var4, float var5);

    public void registerListeners(IEventBus bus) {
        bus.addListener(this::onRenderPlayerHand);
    }

    protected void onRenderPlayerHand(RenderHandEvent event) {
        ItemStack heldItem = event.getItemStack();
        if (!this.appliesTo(heldItem)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        TextureManager textureManager = mc.func_110434_K();
        PlayerRenderer playerrenderer = (PlayerRenderer)mc.func_175598_ae().func_78713_a((Entity)player);
        FirstPersonRenderer firstPersonRenderer = mc.func_175597_ag();
        MatrixStack ms = event.getMatrixStack();
        IRenderTypeBuffer buffer = event.getBuffers();
        int light = event.getLight();
        float pt = event.getPartialTicks();
        boolean rightHand = event.getHand() == Hand.MAIN_HAND ^ mc.field_71439_g.func_184591_cq() == HandSide.LEFT;
        float recoil = rightHand ? MathHelper.func_219799_g((float)pt, (float)this.lastRightHandAnimation, (float)this.rightHandAnimation) : MathHelper.func_219799_g((float)pt, (float)this.lastLeftHandAnimation, (float)this.leftHandAnimation);
        float equipProgress = event.getEquipProgress();
        if (rightHand && (this.rightHandAnimation > 0.01f || this.dontReequipRight)) {
            equipProgress = 0.0f;
        }
        if (!rightHand && (this.leftHandAnimation > 0.01f || this.dontReequipLeft)) {
            equipProgress = 0.0f;
        }
        ms.func_227860_a_();
        textureManager.func_110577_a(player.func_110306_p());
        float flip = rightHand ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)event.getSwingProgress());
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(event.getSwingProgress() * (float)Math.PI));
        float f5 = MathHelper.func_76126_a((float)(event.getSwingProgress() * event.getSwingProgress() * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        ms.func_227861_a_((double)(flip * (f2 + 0.64f - 0.1f)), (double)(f3 + -0.4f + equipProgress * -0.6f), (double)(f4 + -0.72f + 0.3f + recoil));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(flip * 75.0f));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(flip * f6 * 70.0f));
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(flip * f5 * -20.0f));
        ms.func_227861_a_((double)(flip * -1.0f), (double)3.6f, 3.5);
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(flip * 120.0f));
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(200.0f));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(flip * -135.0f));
        ms.func_227861_a_((double)(flip * 5.6f), 0.0, 0.0);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(flip * 40.0f));
        this.transformHand(ms, flip, equipProgress, recoil, pt);
        if (rightHand) {
            playerrenderer.func_229144_a_(ms, buffer, light, (AbstractClientPlayerEntity)player);
        } else {
            playerrenderer.func_229146_b_(ms, buffer, light, (AbstractClientPlayerEntity)player);
        }
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227861_a_((double)(flip * (f2 + 0.64f - 0.1f)), (double)(f3 + -0.4f + equipProgress * -0.6f), (double)(f4 + -0.72f - 0.1f + recoil));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(flip * f6 * 70.0f));
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(flip * f5 * -20.0f));
        this.transformTool(ms, flip, equipProgress, recoil, pt);
        firstPersonRenderer.func_228397_a_((LivingEntity)mc.field_71439_g, heldItem, rightHand ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !rightHand, ms, buffer, light);
        ms.func_227865_b_();
        event.setCanceled(true);
    }

    public void dontAnimateItem(Hand hand) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        boolean rightHand = hand == Hand.MAIN_HAND ^ player.func_184591_cq() == HandSide.LEFT;
        this.dontReequipRight |= rightHand;
        this.dontReequipLeft |= !rightHand;
    }
}

