/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.logistics.block.funnel.AbstractDirectionalFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class FunnelBlock
extends AbstractDirectionalFunnelBlock {
    public static final BooleanProperty EXTRACTING = BooleanProperty.func_177716_a((String)"extracting");

    public FunnelBlock(AbstractBlock.Properties p_i48415_1_) {
        super(p_i48415_1_);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)EXTRACTING, (Comparable)Boolean.valueOf(false)));
    }

    public abstract BlockState getEquivalentBeltFunnel(IBlockReader var1, BlockPos var2, BlockState var3);

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        boolean sneak = context.func_195999_j() != null && context.func_195999_j().func_225608_bj_();
        state = (BlockState)state.func_206870_a((Property)EXTRACTING, (Comparable)Boolean.valueOf(!sneak));
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate = (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_176734_d());
            if (!blockstate.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return (BlockState)blockstate.func_206870_a((Property)POWERED, state.func_177229_b((Property)POWERED));
        }
        return state;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new Property[]{EXTRACTING}));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean shouldntInsertItem;
        ItemStack heldItem = player.func_184586_b(handIn);
        boolean bl = shouldntInsertItem = AllBlocks.MECHANICAL_ARM.isIn(heldItem) || !this.canInsertIntoFunnel(state);
        if (AllItems.WRENCH.isIn(heldItem)) {
            return ActionResultType.PASS;
        }
        if (hit.func_216354_b() == FunnelBlock.getFunnelFacing(state) && !shouldntInsertItem) {
            if (!worldIn.field_72995_K) {
                this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
                    ItemStack toInsert = heldItem.func_77946_l();
                    ItemStack remainder = FunnelBlock.tryInsert(worldIn, pos, toInsert, false);
                    if (!ItemStack.func_77989_b((ItemStack)remainder, (ItemStack)toInsert)) {
                        player.func_184611_a(handIn, remainder);
                    }
                });
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            world.func_175656_a(context.func_195995_a(), (BlockState)state.func_235896_a_((Property)EXTRACTING));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!this.canInsertIntoFunnel(state)) {
            return;
        }
        if (!entityIn.func_70089_S()) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        Direction direction = FunnelBlock.getFunnelFacing(state);
        Vector3d diff = entityIn.func_213303_ch().func_178788_d(VecHelper.getCenterOf((Vector3i)pos).func_178787_e(Vector3d.func_237491_b_((Vector3i)direction.func_176730_m()).func_186678_a((double)-0.325f)));
        double projectedDiff = direction.func_176740_k().func_196051_a(diff.field_72450_a, diff.field_72448_b, diff.field_72449_c);
        if (projectedDiff < 0.0 == (direction.func_176743_c() == Direction.AxisDirection.POSITIVE)) {
            return;
        }
        ItemStack toInsert = itemEntity.func_92059_d();
        ItemStack remainder = FunnelBlock.tryInsert(worldIn, pos, toInsert, false);
        if (remainder.func_190926_b()) {
            itemEntity.func_70106_y();
        }
        if (remainder.func_190916_E() < toInsert.func_190916_E()) {
            itemEntity.func_92058_a(remainder);
        }
    }

    protected boolean canInsertIntoFunnel(BlockState state) {
        return (Boolean)state.func_177229_b((Property)POWERED) == false && (Boolean)state.func_177229_b((Property)EXTRACTING) == false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        return facing == Direction.DOWN ? AllShapes.FUNNEL_CEILING : (facing == Direction.UP ? AllShapes.FUNNEL_FLOOR : AllShapes.FUNNEL_WALL.get(facing));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (context.getEntity() instanceof ItemEntity && this.getFacing(state).func_176740_k().func_176722_c()) {
            return AllShapes.FUNNEL_COLLISION.get(this.getFacing(state));
        }
        return this.func_220053_a(state, world, pos, context);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState p_196271_3_, IWorld world, BlockPos pos, BlockPos p_196271_6_) {
        if (this.getFacing(state).func_176740_k().func_200128_b() || direction != Direction.DOWN) {
            return state;
        }
        BlockState equivalentFunnel = this.getEquivalentBeltFunnel(null, null, state);
        if (BeltFunnelBlock.isOnValidBelt(equivalentFunnel, (IWorldReader)world, pos)) {
            return (BlockState)equivalentFunnel.func_206870_a(BeltFunnelBlock.SHAPE, (Comparable)((Object)BeltFunnelBlock.getShapeForPosition((IBlockReader)world, pos, this.getFacing(state), (Boolean)state.func_177229_b((Property)EXTRACTING))));
        }
        return state;
    }
}

