/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class ArmAngleTarget {
    static ArmAngleTarget NO_TARGET = new ArmAngleTarget();
    float baseAngle;
    float lowerArmAngle;
    float upperArmAngle;
    float headAngle;

    private ArmAngleTarget() {
        this.lowerArmAngle = 155.0f;
        this.upperArmAngle = 60.0f;
        this.headAngle = -15.0f;
    }

    public ArmAngleTarget(BlockPos armPos, Vector3d pointTarget, Direction clawFacing, boolean ceiling) {
        Vector3d target = pointTarget;
        Vector3d origin = VecHelper.getCenterOf((Vector3i)armPos).func_72441_c(0.0, ceiling ? -0.25 : 0.25, 0.0);
        Vector3d clawTarget = target;
        target = target.func_178787_e(Vector3d.func_237491_b_((Vector3i)clawFacing.func_176734_d().func_176730_m()).func_186678_a(0.5));
        Vector3d diff = target.func_178788_d(origin);
        float horizontalDistance = (float)diff.func_216372_d(1.0, 0.0, 1.0).func_72433_c();
        float baseAngle = AngleHelper.deg(MathHelper.func_181159_b((double)diff.field_72450_a, (double)diff.field_72449_c)) + 180.0f;
        if (ceiling) {
            diff = diff.func_216372_d(1.0, -1.0, 1.0);
            baseAngle = 180.0f - baseAngle;
        }
        float alphaOffset = AngleHelper.deg(MathHelper.func_181159_b((double)diff.field_72448_b, (double)horizontalDistance));
        float a = 1.125f;
        float a2 = a * a;
        float b = 1.0625f;
        float b2 = b * b;
        float diffLength = MathHelper.func_76131_a((float)MathHelper.func_76133_a((double)(diff.field_72448_b * diff.field_72448_b + (double)(horizontalDistance * horizontalDistance))), (float)0.125f, (float)(a + b));
        float diffLength2 = diffLength * diffLength;
        float alphaRatio = (-b2 + a2 + diffLength2) / (2.0f * a * diffLength);
        float alpha = AngleHelper.deg(Math.acos(alphaRatio)) + alphaOffset;
        float betaRatio = (-diffLength2 + a2 + b2) / (2.0f * b * a);
        float beta = AngleHelper.deg(Math.acos(betaRatio));
        if (Float.isNaN(alpha)) {
            alpha = 0.0f;
        }
        if (Float.isNaN(beta)) {
            beta = 0.0f;
        }
        Vector3d headPos = new Vector3d(0.0, 0.0, 0.0);
        headPos = VecHelper.rotate(headPos.func_72441_c(0.0, (double)b, 0.0), beta + 180.0f, Direction.Axis.X);
        headPos = VecHelper.rotate(headPos.func_72441_c(0.0, (double)a, 0.0), alpha - 90.0f, Direction.Axis.X);
        headPos = VecHelper.rotate(headPos, baseAngle, Direction.Axis.Y);
        headPos = VecHelper.rotate(headPos, ceiling ? 180.0 : 0.0, Direction.Axis.X);
        headPos = headPos.func_178787_e(origin);
        Vector3d headDiff = clawTarget.func_178788_d(headPos);
        if (ceiling) {
            headDiff = headDiff.func_216372_d(1.0, -1.0, 1.0);
        }
        float horizontalHeadDistance = (float)headDiff.func_216372_d(1.0, 0.0, 1.0).func_72433_c();
        float headAngle = alpha + beta + 135.0f - AngleHelper.deg(MathHelper.func_181159_b((double)headDiff.field_72448_b, (double)horizontalHeadDistance));
        this.lowerArmAngle = alpha;
        this.upperArmAngle = beta;
        this.headAngle = -headAngle;
        this.baseAngle = baseAngle;
    }
}

