/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.item.LecternControllerBlock;
import com.simibubi.create.content.logistics.item.LinkedControllerClientHandler;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.DistExecutor;

public class LecternControllerTileEntity
extends SmartTileEntity {
    private ItemStack controller;
    private UUID user;
    private UUID prevUser;
    private boolean deactivatedThisTick;

    public LecternControllerTileEntity(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.func_218657_a("Controller", (INBT)this.controller.func_77955_b(new CompoundNBT()));
        if (this.user != null) {
            compound.func_186854_a("User", this.user);
        }
    }

    @Override
    public void writeSafe(CompoundNBT compound, boolean clientPacket) {
        super.writeSafe(compound, clientPacket);
        compound.func_218657_a("Controller", (INBT)this.controller.func_77955_b(new CompoundNBT()));
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.controller = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Controller"));
        this.user = compound.func_186855_b("User") ? compound.func_186857_a("User") : null;
    }

    public ItemStack getController() {
        return this.controller;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public boolean isUsedBy(PlayerEntity player) {
        return this.hasUser() && this.user.equals(player.func_110124_au());
    }

    public void tryStartUsing(PlayerEntity player) {
        if (!this.deactivatedThisTick && !this.hasUser() && !LecternControllerTileEntity.playerIsUsingLectern(player) && LecternControllerTileEntity.playerInRange(player, this.field_145850_b, this.field_174879_c)) {
            this.startUsing(player);
        }
    }

    public void tryStopUsing(PlayerEntity player) {
        if (this.isUsedBy(player)) {
            this.stopUsing(player);
        }
    }

    private void startUsing(PlayerEntity player) {
        this.user = player.func_110124_au();
        player.getPersistentData().func_74757_a("IsUsingLecternController", true);
        this.sendData();
    }

    private void stopUsing(PlayerEntity player) {
        this.user = null;
        if (player != null) {
            player.getPersistentData().func_82580_o("IsUsingLecternController");
        }
        this.deactivatedThisTick = true;
        this.sendData();
    }

    public static boolean playerIsUsingLectern(PlayerEntity player) {
        return player.getPersistentData().func_74764_b("IsUsingLecternController");
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::tryToggleActive);
            this.prevUser = this.user;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.deactivatedThisTick = false;
            if (!(this.field_145850_b instanceof ServerWorld)) {
                return;
            }
            if (this.user == null) {
                return;
            }
            Entity entity = ((ServerWorld)this.field_145850_b).func_217461_a(this.user);
            if (!(entity instanceof PlayerEntity)) {
                this.stopUsing(null);
                return;
            }
            PlayerEntity player = (PlayerEntity)entity;
            if (!LecternControllerTileEntity.playerInRange(player, this.field_145850_b, this.field_174879_c) || !LecternControllerTileEntity.playerIsUsingLectern(player)) {
                this.stopUsing(player);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tryToggleActive() {
        if (this.user == null && Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(this.prevUser)) {
            LinkedControllerClientHandler.deactivateInLectern();
        } else if (this.prevUser == null && Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(this.user)) {
            LinkedControllerClientHandler.activateInLectern(this.field_174879_c);
        }
    }

    public void setController(ItemStack newController) {
        this.controller = newController;
        if (newController != null) {
            AllSoundEvents.CONTROLLER_PUT.playOnServer(this.field_145850_b, this.field_174879_c);
        }
    }

    public void swapControllers(ItemStack stack, PlayerEntity player, Hand hand, BlockState state) {
        ItemStack newController = stack.func_77946_l();
        stack.func_190920_e(0);
        if (player.func_184586_b(hand).func_190926_b()) {
            player.func_184611_a(hand, this.controller);
        } else {
            this.dropController(state);
        }
        this.setController(newController);
    }

    public void dropController(BlockState state) {
        Entity playerEntity = ((ServerWorld)this.field_145850_b).func_217461_a(this.user);
        if (playerEntity instanceof PlayerEntity) {
            this.stopUsing((PlayerEntity)playerEntity);
        }
        Direction dir = (Direction)state.func_177229_b((Property)LecternControllerBlock.field_220156_a);
        double x = (double)this.field_174879_c.func_177958_n() + 0.5 + 0.25 * (double)dir.func_82601_c();
        double y = this.field_174879_c.func_177956_o() + 1;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5 + 0.25 * (double)dir.func_82599_e();
        ItemEntity itementity = new ItemEntity(this.field_145850_b, x, y, z, this.controller.func_77946_l());
        itementity.func_174869_p();
        this.field_145850_b.func_217376_c((Entity)itementity);
        this.controller = null;
    }

    public static boolean playerInRange(PlayerEntity player, World world, BlockPos pos) {
        double reach = 0.4 * player.func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get());
        return player.func_195048_a(Vector3d.func_237489_a_((Vector3i)pos)) < reach * reach;
    }
}

