/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.logistics.item.filter.AbstractFilterContainer;
import com.simibubi.create.content.logistics.item.filter.FilterScreenPacket;
import com.simibubi.create.foundation.gui.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Indicator;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class AbstractFilterScreen<F extends AbstractFilterContainer>
extends AbstractSimiContainerScreen<F> {
    protected AllGuiTextures background;
    private List<Rectangle2d> extraAreas = Collections.emptyList();
    private IconButton resetButton;
    private IconButton confirmButton;

    protected AbstractFilterScreen(F container, PlayerInventory inv, ITextComponent title, AllGuiTextures background) {
        super(container, inv, title);
        this.background = background;
    }

    @Override
    protected void func_231160_c_() {
        this.setWindowSize(Math.max(this.background.width, AllGuiTextures.PLAYER_INVENTORY.width), this.background.height + 4 + AllGuiTextures.PLAYER_INVENTORY.height);
        super.func_231160_c_();
        this.widgets.clear();
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        this.resetButton = new IconButton(x + this.background.width - 62, y + this.background.height - 24, AllIcons.I_TRASH);
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.widgets.add(this.resetButton);
        this.widgets.add(this.confirmButton);
        this.extraAreas = ImmutableList.of((Object)new Rectangle2d(x + this.background.width, y + this.background.height - 40, 80, 48));
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.field_147009_r + this.background.height + 4;
        this.renderPlayerInventory(ms, invX, invY);
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        this.background.draw(ms, (AbstractGui)this, x, y);
        AbstractFilterScreen.func_238472_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(x + (this.background.width - 8) / 2), (int)(y + 3), (int)0xFFFFFF);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)((AbstractFilterContainer)this.field_147002_h).contentHolder).at(x + this.background.width, y + this.background.height - 56, -200.0f)).scale(5.0).render(ms);
    }

    public void func_231023_e_() {
        this.handleTooltips();
        super.func_231023_e_();
        this.handleIndicators();
        if (!((AbstractFilterContainer)this.field_147002_h).player.func_184614_ca().equals((ItemStack)((AbstractFilterContainer)this.field_147002_h).contentHolder, false)) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
    }

    public void handleIndicators() {
        List<IconButton> tooltipButtons = this.getTooltipButtons();
        for (IconButton button : tooltipButtons) {
            button.field_230693_o_ = this.isButtonEnabled(button);
        }
        for (Widget w : this.widgets) {
            if (!(w instanceof Indicator)) continue;
            ((Indicator)w).state = this.isIndicatorOn((Indicator)w) ? Indicator.State.ON : Indicator.State.OFF;
        }
    }

    protected abstract boolean isButtonEnabled(IconButton var1);

    protected abstract boolean isIndicatorOn(Indicator var1);

    protected void handleTooltips() {
        List<IconButton> tooltipButtons = this.getTooltipButtons();
        for (IconButton button : tooltipButtons) {
            if (button.getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().get(0));
            button.getToolTip().add((ITextComponent)TooltipHelper.holdShift(ItemDescription.Palette.Yellow, AbstractFilterScreen.func_231173_s_()));
        }
        if (AbstractFilterScreen.func_231173_s_()) {
            List<IFormattableTextComponent> tooltipDescriptions = this.getTooltipDescriptions();
            for (int i = 0; i < tooltipButtons.size(); ++i) {
                this.fillToolTip(tooltipButtons.get(i), (ITextComponent)tooltipDescriptions.get(i));
            }
        }
    }

    protected List<IconButton> getTooltipButtons() {
        return Collections.emptyList();
    }

    protected List<IFormattableTextComponent> getTooltipDescriptions() {
        return Collections.emptyList();
    }

    private void fillToolTip(IconButton button, ITextComponent tooltip) {
        if (!button.func_230449_g_()) {
            return;
        }
        List<ITextComponent> tip = button.getToolTip();
        tip.addAll(TooltipHelper.cutTextComponent(tooltip, TextFormatting.GRAY, TextFormatting.GRAY));
    }

    @Override
    public boolean func_231044_a_(double x, double y, int button) {
        boolean mouseClicked = super.func_231044_a_(x, y, button);
        if (button == 0) {
            if (this.confirmButton.func_230449_g_()) {
                this.field_230706_i_.field_71439_g.func_71053_j();
                return true;
            }
            if (this.resetButton.func_230449_g_()) {
                ((AbstractFilterContainer)this.field_147002_h).clearContents();
                this.contentsCleared();
                ((AbstractFilterContainer)this.field_147002_h).sendClearPacket();
                return true;
            }
        }
        return mouseClicked;
    }

    protected void contentsCleared() {
    }

    protected void sendOptionUpdate(FilterScreenPacket.Option option) {
        AllPackets.channel.sendToServer((Object)new FilterScreenPacket(option));
    }

    @Override
    public List<Rectangle2d> getExtraAreas() {
        return this.extraAreas;
    }
}

