/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.LazyOptional;

public class CouplingCommand {
    public static final SimpleCommandExceptionType ONLY_MINECARTS_ALLOWED = new SimpleCommandExceptionType((Message)new StringTextComponent("Only Minecarts can be coupled"));
    public static final SimpleCommandExceptionType SAME_DIMENSION = new SimpleCommandExceptionType((Message)new StringTextComponent("Minecarts have to be in the same Dimension"));
    public static final DynamicCommandExceptionType TWO_CARTS = new DynamicCommandExceptionType(a -> new StringTextComponent("Your selector targeted " + a + " entities. You can only couple 2 Minecarts at a time."));

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"coupling").requires(cs -> cs.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"cart1", (ArgumentType)EntityArgument.func_197086_a()).then(Commands.func_197056_a((String)"cart2", (ArgumentType)EntityArgument.func_197086_a()).executes(ctx -> {
            Entity cart1 = EntityArgument.func_197088_a((CommandContext)ctx, (String)"cart1");
            if (!(cart1 instanceof AbstractMinecartEntity)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            Entity cart2 = EntityArgument.func_197088_a((CommandContext)ctx, (String)"cart2");
            if (!(cart2 instanceof AbstractMinecartEntity)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            if (!cart1.func_130014_f_().equals(cart2.func_130014_f_())) {
                throw SAME_DIMENSION.create();
            }
            Entity source = ((CommandSource)ctx.getSource()).func_197022_f();
            CouplingHandler.tryToCoupleCarts(source instanceof PlayerEntity ? (PlayerEntity)source : null, cart1.func_130014_f_(), cart1.func_145782_y(), cart2.func_145782_y());
            return 1;
        })))).then(Commands.func_197056_a((String)"carts", (ArgumentType)EntityArgument.func_197093_b()).executes(ctx -> {
            Collection entities = EntityArgument.func_197097_b((CommandContext)ctx, (String)"carts");
            if (entities.size() != 2) {
                throw TWO_CARTS.create((Object)entities.size());
            }
            ArrayList eList = Lists.newArrayList((Iterable)entities);
            Entity cart1 = (Entity)eList.get(0);
            if (!(cart1 instanceof AbstractMinecartEntity)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            Entity cart2 = (Entity)eList.get(1);
            if (!(cart2 instanceof AbstractMinecartEntity)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            if (!cart1.func_130014_f_().equals(cart2.func_130014_f_())) {
                throw SAME_DIMENSION.create();
            }
            Entity source = ((CommandSource)ctx.getSource()).func_197022_f();
            CouplingHandler.tryToCoupleCarts(source instanceof PlayerEntity ? (PlayerEntity)source : null, cart1.func_130014_f_(), cart1.func_145782_y(), cart2.func_145782_y());
            return 1;
        })))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"cart1", (ArgumentType)EntityArgument.func_197086_a()).then(Commands.func_197056_a((String)"cart2", (ArgumentType)EntityArgument.func_197086_a()).executes(ctx -> {
            Entity cart1 = EntityArgument.func_197088_a((CommandContext)ctx, (String)"cart1");
            if (!(cart1 instanceof AbstractMinecartEntity)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            Entity cart2 = EntityArgument.func_197088_a((CommandContext)ctx, (String)"cart2");
            if (!(cart2 instanceof AbstractMinecartEntity)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            LazyOptional cart1Capability = cart1.getCapability(CapabilityMinecartController.MINECART_CONTROLLER_CAPABILITY);
            if (!cart1Capability.isPresent()) {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Minecart has no Couplings Attached"), true);
                return 0;
            }
            MinecartController cart1Controller = (MinecartController)cart1Capability.orElse(null);
            int cart1Couplings = (cart1Controller.isConnectedToCoupling() ? 1 : 0) + (cart1Controller.isLeadingCoupling() ? 1 : 0);
            if (cart1Couplings == 0) {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Minecart has no Couplings Attached"), true);
                return 0;
            }
            for (boolean bool : Iterate.trueAndFalse) {
                UUID coupledCart = cart1Controller.getCoupledCart(bool);
                if (coupledCart == null || coupledCart != cart2.func_110124_au()) continue;
                MinecartController cart2Controller = CapabilityMinecartController.getIfPresent(cart1.func_130014_f_(), coupledCart);
                if (cart2Controller == null) {
                    return 0;
                }
                cart1Controller.removeConnection(bool);
                cart2Controller.removeConnection(!bool);
                return 1;
            }
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("The specified Carts are not coupled"), true);
            return 0;
        }))))).then(Commands.func_197057_a((String)"removeAll").then(Commands.func_197056_a((String)"cart", (ArgumentType)EntityArgument.func_197086_a()).executes(ctx -> {
            Entity cart = EntityArgument.func_197088_a((CommandContext)ctx, (String)"cart");
            if (!(cart instanceof AbstractMinecartEntity)) {
                throw ONLY_MINECARTS_ALLOWED.create();
            }
            LazyOptional capability = cart.getCapability(CapabilityMinecartController.MINECART_CONTROLLER_CAPABILITY);
            if (!capability.isPresent()) {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Minecart has no Couplings Attached"), true);
                return 0;
            }
            MinecartController controller = (MinecartController)capability.orElse(null);
            int couplings = (controller.isConnectedToCoupling() ? 1 : 0) + (controller.isLeadingCoupling() ? 1 : 0);
            if (couplings == 0) {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Minecart has no Couplings Attached"), true);
                return 0;
            }
            controller.decouple();
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Removed " + couplings + " couplings from the Minecart"), true);
            return couplings;
        })));
    }
}

