/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.simibubi.create.foundation.gui.IInteractionChecker;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ContainerBase<T>
extends Container {
    public PlayerEntity player;
    public PlayerInventory playerInventory;
    public T contentHolder;

    protected ContainerBase(ContainerType<?> type, int id, PlayerInventory inv, PacketBuffer extraData) {
        super(type, id);
        this.init(inv, this.createOnClient(extraData));
    }

    protected ContainerBase(ContainerType<?> type, int id, PlayerInventory inv, T contentHolder) {
        super(type, id);
        this.init(inv, contentHolder);
    }

    protected void init(PlayerInventory inv, T contentHolderIn) {
        this.player = inv.field_70458_d;
        this.playerInventory = inv;
        this.contentHolder = contentHolderIn;
        this.initAndReadInventory(this.contentHolder);
        this.addSlots();
        this.func_75142_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract T createOnClient(PacketBuffer var1);

    protected abstract void addSlots();

    protected abstract void initAndReadInventory(T var1);

    protected abstract void saveData(T var1);

    protected void addPlayerSlots(int x, int y) {
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, hotbarSlot, x + hotbarSlot * 18, y + 58));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.saveData(this.contentHolder);
    }

    public boolean func_75145_c(PlayerEntity player) {
        if (this.contentHolder == null) {
            return false;
        }
        if (this.contentHolder instanceof IInteractionChecker) {
            return ((IInteractionChecker)this.contentHolder).canPlayerUse(player);
        }
        return true;
    }
}

