/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.gui.BoxElement;
import com.simibubi.create.foundation.gui.DelegatedStencilElement;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widgets.ElementWidget;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class BoxWidget
extends ElementWidget {
    public static final Function<BoxWidget, DelegatedStencilElement.ElementRenderer> gradientFactory = box -> (ms, w, h, alpha) -> UIRenderHelper.angledGradient(ms, 90.0f, w / 2, -2, w + 4, h + 4, box.gradientColor1, box.gradientColor2);
    protected BoxElement box;
    protected Color customBorderTop;
    protected Color customBorderBot;
    protected Color customBackground;
    protected boolean animateColors = true;
    protected LerpedFloat colorAnimation = LerpedFloat.linear();
    protected Color gradientColor1;
    protected Color gradientColor2;
    private Color previousColor1;
    private Color previousColor2;
    private Color colorTarget1 = Theme.c(this.getIdleTheme(), true).copy();
    private Color colorTarget2 = Theme.c(this.getIdleTheme(), false).copy();

    public BoxWidget() {
        this(0, 0);
    }

    public BoxWidget(int x, int y) {
        this(x, y, 16, 16);
    }

    public BoxWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.box = (BoxElement)((RenderElement)new BoxElement().at(x, y)).withBounds(width, height);
        this.gradientColor1 = this.colorTarget1;
        this.gradientColor2 = this.colorTarget2;
    }

    public <T extends BoxWidget> T withBounds(int width, int height) {
        this.field_230688_j_ = width;
        this.field_230689_k_ = height;
        return (T)((Object)this);
    }

    public <T extends BoxWidget> T withBorderColors(Couple<Color> colors) {
        this.customBorderTop = (Color)colors.getFirst();
        this.customBorderBot = (Color)colors.getSecond();
        this.updateColorsFromState();
        return (T)((Object)this);
    }

    public <T extends BoxWidget> T withBorderColors(Color top, Color bot) {
        this.customBorderTop = top;
        this.customBorderBot = bot;
        this.updateColorsFromState();
        return (T)((Object)this);
    }

    public <T extends BoxWidget> T withCustomBackground(Color color) {
        this.customBackground = color;
        return (T)((Object)this);
    }

    public <T extends BoxWidget> T animateColors(boolean b) {
        this.animateColors = b;
        return (T)((Object)this);
    }

    @Override
    public void tick() {
        super.tick();
        this.colorAnimation.tickChaser();
    }

    @Override
    public void func_230982_a_(double x, double y) {
        super.func_230982_a_(x, y);
        this.gradientColor1 = Theme.c(this.getClickTheme(), true);
        this.gradientColor2 = Theme.c(this.getClickTheme(), false);
        this.startGradientAnimation(this.getColorForState(true), this.getColorForState(false), true, 0.15);
    }

    @Override
    protected void beforeRender(@Nonnull MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(ms, mouseX, mouseY, partialTicks);
        if (this.field_230692_n_ != this.field_230685_b_) {
            this.startGradientAnimation(this.getColorForState(true), this.getColorForState(false), this.field_230692_n_);
        }
        if (this.colorAnimation.settled()) {
            this.gradientColor1 = this.colorTarget1;
            this.gradientColor2 = this.colorTarget2;
        } else {
            float animationValue = 1.0f - Math.abs(this.colorAnimation.getValue(partialTicks));
            this.gradientColor1 = Color.mixColors(this.previousColor1, this.colorTarget1, animationValue);
            this.gradientColor2 = Color.mixColors(this.previousColor2, this.colorTarget2, animationValue);
        }
    }

    @Override
    public void func_230431_b_(@Nonnull MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        float fadeValue = this.fade.getValue(partialTicks);
        if (fadeValue < 0.1f) {
            return;
        }
        this.box.withAlpha(fadeValue);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)this.box.withBackground(this.customBackground != null ? this.customBackground : Theme.c(Theme.Key.PONDER_BACKGROUND_TRANSPARENT))).gradientBorder(this.gradientColor1, this.gradientColor2)).at(this.field_230690_l_, this.field_230691_m_, this.z)).withBounds(this.field_230688_j_, this.field_230689_k_)).render(ms);
        super.func_230431_b_(ms, mouseX, mouseY, partialTicks);
        this.field_230685_b_ = this.field_230692_n_;
    }

    public boolean func_231047_b_(double mX, double mY) {
        if (!this.field_230693_o_ || !this.field_230694_p_) {
            return false;
        }
        return (double)(this.field_230690_l_ - 4) <= mX && (double)(this.field_230691_m_ - 4) <= mY && mX <= (double)(this.field_230690_l_ + 4 + this.field_230688_j_) && mY <= (double)(this.field_230691_m_ + 4 + this.field_230689_k_);
    }

    public BoxElement getBox() {
        return this.box;
    }

    public void updateColorsFromState() {
        this.colorTarget1 = this.getColorForState(true);
        this.colorTarget2 = this.getColorForState(false);
    }

    public void animateGradientFromState() {
        this.startGradientAnimation(this.getColorForState(true), this.getColorForState(false), true);
    }

    private void startGradientAnimation(Color c1, Color c2, boolean positive, double expSpeed) {
        if (!this.animateColors) {
            return;
        }
        this.colorAnimation.startWithValue(positive ? 1.0 : -1.0);
        this.colorAnimation.chase(0.0, expSpeed, LerpedFloat.Chaser.EXP);
        this.colorAnimation.tickChaser();
        this.previousColor1 = this.gradientColor1;
        this.previousColor2 = this.gradientColor2;
        this.colorTarget1 = c1;
        this.colorTarget2 = c2;
    }

    private void startGradientAnimation(Color c1, Color c2, boolean positive) {
        this.startGradientAnimation(c1, c2, positive, 0.6);
    }

    private Color getColorForState(boolean first) {
        if (!this.field_230693_o_) {
            return Theme.p(this.getDisabledTheme()).get(first);
        }
        if (this.field_230692_n_) {
            if (first) {
                return this.customBorderTop != null ? this.customBorderTop.darker() : Theme.c(this.getHoverTheme(), true);
            }
            return this.customBorderBot != null ? this.customBorderBot.darker() : Theme.c(this.getHoverTheme(), false);
        }
        if (first) {
            return this.customBorderTop != null ? this.customBorderTop : Theme.c(this.getIdleTheme(), true);
        }
        return this.customBorderBot != null ? this.customBorderBot : Theme.c(this.getIdleTheme(), false);
    }

    public Theme.Key getDisabledTheme() {
        return Theme.Key.BUTTON_DISABLE;
    }

    public Theme.Key getIdleTheme() {
        return Theme.Key.BUTTON_IDLE;
    }

    public Theme.Key getHoverTheme() {
        return Theme.Key.BUTTON_HOVER;
    }

    public Theme.Key getClickTheme() {
        return Theme.Key.BUTTON_CLICK;
    }
}

