/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class RailgunHandler {
    public static List<Pair<Supplier<Ingredient>, IRailgunProjectile>> projectilePropertyMap = new ArrayList<Pair<Supplier<Ingredient>, IRailgunProjectile>>();

    public static IRailgunProjectile registerProjectile(Supplier<Ingredient> stack, IRailgunProjectile properties) {
        projectilePropertyMap.add((Pair<Supplier<Ingredient>, IRailgunProjectile>)Pair.of(stack, (Object)properties));
        return properties;
    }

    public static StandardRailgunProjectile registerStandardProjectile(ITag<Item> tag, double damage, double gravity) {
        return (StandardRailgunProjectile)RailgunHandler.registerProjectile(() -> Ingredient.func_199805_a((ITag)tag), new StandardRailgunProjectile(damage, gravity));
    }

    public static StandardRailgunProjectile registerStandardProjectile(ItemStack stack, double damage, double gravity) {
        return (StandardRailgunProjectile)RailgunHandler.registerProjectile(() -> Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}), new StandardRailgunProjectile(damage, gravity));
    }

    public static IRailgunProjectile getProjectile(ItemStack stack) {
        for (Pair<Supplier<Ingredient>, IRailgunProjectile> pair : projectilePropertyMap) {
            if (!((Ingredient)((Supplier)pair.getLeft()).get()).test(stack)) continue;
            return (IRailgunProjectile)pair.getRight();
        }
        return null;
    }

    public static class StandardRailgunProjectile
    implements IRailgunProjectile {
        private final double damage;
        private final double gravity;
        private RailgunRenderColors colorMap;

        public StandardRailgunProjectile(double damage, double gravity) {
            this.damage = damage;
            this.gravity = gravity;
        }

        public StandardRailgunProjectile setColorMap(RailgunRenderColors map) {
            this.colorMap = map;
            return this;
        }

        public RailgunRenderColors getColorMap() {
            return this.colorMap;
        }

        @Override
        public double getGravity() {
            return this.gravity;
        }

        @Override
        public double getDamage(World world, Entity target, @Nullable UUID shooter, Entity projectile) {
            return this.damage;
        }

        @Override
        public boolean isValidForTurret() {
            return true;
        }
    }

    public static interface IRailgunProjectile {
        default public Entity getProjectile(@Nullable PlayerEntity shooter, ItemStack ammo, Entity defaultProjectile) {
            return defaultProjectile;
        }

        default public double getGravity() {
            return 1.0;
        }

        default public double getDamage(World world, Entity target, @Nullable UUID shooter, Entity projectile) {
            return 0.0;
        }

        default public void onHitTarget(World world, RayTraceResult target, @Nullable UUID shooter, Entity projectile) {
        }

        default public double getBreakChance(@Nullable UUID shooter, ItemStack ammo) {
            return 0.25;
        }

        default public boolean isValidForTurret() {
            return false;
        }
    }

    public static class RailgunRenderColors {
        private final List<int[]> rings;
        private final int gradientLength;

        public RailgunRenderColors(int[] ... rings) {
            Preconditions.checkArgument((rings.length > 0 ? 1 : 0) != 0, (Object)"Railgun render colors can not be instantiated with no data");
            this.rings = Arrays.asList(rings);
            this.gradientLength = rings[0].length;
            for (int[] ring : rings) {
                Preconditions.checkArgument((ring.length == this.gradientLength ? 1 : 0) != 0, (Object)"All rings in Railgun render must have the same length");
            }
        }

        public RailgunRenderColors(int ... color) {
            this(new int[][]{color});
        }

        public int getRingCount() {
            return this.rings.size();
        }

        public int getGradientLength() {
            return this.gradientLength;
        }

        private static int[] splitRGB(int rgb) {
            return new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF};
        }

        public int[] getRingColor(int lengthIdx, int widthIdx) {
            return RailgunRenderColors.splitRGB(this.rings.get(lengthIdx)[widthIdx]);
        }

        public int[] getFrontColor(int widthIdx) {
            return RailgunRenderColors.splitRGB(this.rings.get(0)[widthIdx]);
        }

        public int[] getBackColor(int widthIdx) {
            return RailgunRenderColors.splitRGB(this.rings.get(this.rings.size() - 1)[widthIdx]);
        }
    }
}

