/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils.shapes;

import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.api.utils.shapes.ShapeUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class CachedShapesWithTransform<ShapeKey, TransformKey>
extends CachedVoxelShapes<Pair<ShapeKey, TransformKey>> {
    public CachedShapesWithTransform(Function<ShapeKey, List<AxisAlignedBB>> creator, BiFunction<TransformKey, AxisAlignedBB, AxisAlignedBB> transform) {
        super(p -> {
            List base = (List)creator.apply(p.getLeft());
            if (base == null) {
                return ImmutableList.of();
            }
            ArrayList<AxisAlignedBB> ret = new ArrayList<AxisAlignedBB>(base.size());
            for (AxisAlignedBB aabb : base) {
                ret.add((AxisAlignedBB)transform.apply(p.getRight(), aabb));
            }
            return ret;
        });
    }

    public VoxelShape get(ShapeKey shapeKey, TransformKey transformKey) {
        return this.get(Pair.of(shapeKey, transformKey));
    }

    public static CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> createForMultiblock(Function<BlockPos, List<AxisAlignedBB>> create) {
        return new CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>>(create, (key, box) -> CachedShapesWithTransform.withFacingAndMirror(box, (Direction)key.getLeft(), (Boolean)key.getRight()));
    }

    public static AxisAlignedBB withFacingAndMirror(AxisAlignedBB in, Direction d, boolean mirror) {
        AxisAlignedBB mirrored = in;
        if (mirror) {
            mirrored = new AxisAlignedBB(1.0 - in.field_72340_a, in.field_72338_b, in.field_72339_c, 1.0 - in.field_72336_d, in.field_72337_e, in.field_72334_f);
        }
        return ShapeUtils.transformAABB(mirrored, d);
    }

    public static <T> CachedShapesWithTransform<T, Direction> createDirectional(Function<T, List<AxisAlignedBB>> create) {
        return new CachedShapesWithTransform<T, Direction>(create, (key, box) -> ShapeUtils.transformAABB(box, key));
    }
}

