/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BinaryHeap<T> {
    private final Comparator<T> compare;
    private List<HeapEntry<T>> storage = new ArrayList<HeapEntry<T>>();

    public BinaryHeap(Comparator<T> compare) {
        this.compare = compare;
    }

    public HeapEntry<T> insert(T newElement) {
        HeapEntry<T> ret = new HeapEntry<T>(newElement, this.storage.size(), this);
        this.storage.add(ret);
        this.siftUp(ret);
        return ret;
    }

    public T extractMin() {
        HeapEntry<T> ret = this.storage.get(0);
        this.swap(0, -1);
        this.storage.remove(this.storage.size() - 1);
        ((HeapEntry)ret).invalidate();
        if (!this.empty()) {
            this.siftDown(this.storage.get(0));
        }
        return ret.getValue();
    }

    public void decreaseKey(HeapEntry<T> entry) {
        ((HeapEntry)entry).testValidity(this);
        this.siftUp(entry);
    }

    public boolean empty() {
        return this.storage.isEmpty();
    }

    private void siftDown(HeapEntry<T> entry) {
        while (entry != null) {
            Optional<HeapEntry<T>> left = this.left(entry);
            Optional<HeapEntry<T>> right = this.right(entry);
            HeapEntry<T> min = entry;
            if (left.isPresent() && this.compare.compare(left.get().getValue(), min.getValue()) < 0) {
                min = left.get();
            }
            if (right.isPresent() && this.compare.compare(right.get().getValue(), min.getValue()) < 0) {
                min = right.get();
            }
            if (min != entry) {
                this.swap(((HeapEntry)min).location, ((HeapEntry)entry).location);
                continue;
            }
            entry = null;
        }
    }

    private void siftUp(HeapEntry<T> entry) {
        while (entry != null) {
            Optional<HeapEntry<T>> up = this.up(entry);
            if (up.isPresent() && this.compare.compare(up.get().getValue(), entry.getValue()) > 0) {
                this.swap(((HeapEntry)entry).getLocation(), ((HeapEntry)up.get()).getLocation());
                continue;
            }
            entry = null;
        }
    }

    private void swap(int indexA, int indexB) {
        if (indexA == indexB) {
            return;
        }
        if (indexA < 0) {
            indexA += this.storage.size();
        }
        if (indexB < 0) {
            indexB += this.storage.size();
        }
        HeapEntry<T> entryA = this.storage.get(indexA);
        HeapEntry<T> entryB = this.storage.get(indexB);
        ((HeapEntry)entryA).setLocation(indexB);
        ((HeapEntry)entryB).setLocation(indexA);
        this.storage.set(indexA, entryB);
        this.storage.set(indexB, entryA);
    }

    private Optional<HeapEntry<T>> up(HeapEntry<T> here) {
        if (((HeapEntry)here).getLocation() == 0) {
            return Optional.empty();
        }
        return Optional.of(this.storage.get((((HeapEntry)here).getLocation() - 1) / 2));
    }

    private Optional<HeapEntry<T>> left(HeapEntry<T> here) {
        int retIndex = ((HeapEntry)here).getLocation() * 2 + 1;
        if (retIndex < this.storage.size()) {
            return Optional.of(this.storage.get(retIndex));
        }
        return Optional.empty();
    }

    private Optional<HeapEntry<T>> right(HeapEntry<T> here) {
        int retIndex = ((HeapEntry)here).getLocation() * 2 + 2;
        if (retIndex < this.storage.size()) {
            return Optional.of(this.storage.get(retIndex));
        }
        return Optional.empty();
    }

    private void validate() {
        for (HeapEntry<T> entry : this.storage) {
            ((HeapEntry)entry).testValidity(this);
            Optional<HeapEntry<T>> right = this.right(entry);
            Preconditions.checkState((!right.isPresent() || this.compare.compare(right.get().getValue(), entry.getValue()) >= 0 ? 1 : 0) != 0);
            Optional<HeapEntry<T>> left = this.left(entry);
            Preconditions.checkState((!left.isPresent() || this.compare.compare(left.get().getValue(), entry.getValue()) >= 0 ? 1 : 0) != 0);
        }
    }

    public static class HeapEntry<T> {
        private final T value;
        private int location;
        @Nullable
        private BinaryHeap<T> owner;

        public HeapEntry(T value, int location, @Nonnull BinaryHeap<T> owner) {
            this.value = value;
            this.location = location;
            this.owner = owner;
        }

        private int getLocation() {
            return this.location;
        }

        private void setLocation(int newValue) {
            this.location = newValue;
        }

        public T getValue() {
            return this.value;
        }

        private void invalidate() {
            this.owner = null;
        }

        private void testValidity(BinaryHeap<T> potentialOwner) {
            Preconditions.checkArgument((potentialOwner == this.owner ? 1 : 0) != 0);
        }
    }
}

