/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.common.util.sound.IETileSound;
import blusunrize.immersiveengineering.mixin.accessors.client.FontResourceManagerAccess;
import blusunrize.immersiveengineering.mixin.accessors.client.MinecraftAccess;
import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.gui.fonts.FontResourceManager;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector4f;
import org.apache.commons.compress.utils.IOUtils;

public class ClientUtils {
    private static FontRenderer unicodeRenderer;

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static void bindTexture(ResourceLocation texture) {
        ClientUtils.mc().func_110434_K().func_110577_a(texture);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation rl) {
        return ClientUtils.mc().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(rl);
    }

    public static FontRenderer font() {
        return ClientUtils.mc().field_71466_p;
    }

    public static float partialTicks() {
        return ClientUtils.mc().func_184121_ak();
    }

    public static BufferedImage readBufferedImage(InputStream imageStream) throws IOException {
        BufferedImage bufferedimage;
        try {
            bufferedimage = ImageIO.read(imageStream);
        }
        finally {
            IOUtils.closeQuietly((Closeable)imageStream);
        }
        return bufferedimage;
    }

    public static FontRenderer unicodeFontRender() {
        if (unicodeRenderer == null) {
            unicodeRenderer = new FontRenderer(rl -> {
                FontResourceManager resourceManager = ((MinecraftAccess)Minecraft.func_71410_x()).getFontManager();
                Map<ResourceLocation, Font> fonts = ((FontResourceManagerAccess)resourceManager).getFontSets();
                return fonts.get(Minecraft.field_238177_c_);
            });
        }
        return unicodeRenderer;
    }

    public static int getDarkenedTextColour(int colour) {
        int r = (colour >> 16 & 0xFF) / 4;
        int g = (colour >> 8 & 0xFF) / 4;
        int b = (colour & 0xFF) / 4;
        return r << 16 | g << 8 | b;
    }

    public static IETileSound generatePositionedIESound(SoundEvent soundEvent, float volume, float pitch, boolean repeat, int delay, BlockPos pos) {
        IETileSound sound = new IETileSound(soundEvent, volume, pitch, repeat, delay, pos, ISound.AttenuationType.LINEAR, SoundCategory.BLOCKS);
        sound.evaluateVolume();
        ClientUtils.mc().func_147118_V().func_147682_a((ISound)sound);
        return sound;
    }

    public static Quaternion degreeToQuaterion(double x, double y, double z) {
        x = Math.toRadians(x);
        y = Math.toRadians(y);
        z = Math.toRadians(z);
        Quaternion qYaw = new Quaternion(0.0f, (float)Math.sin(y / 2.0), 0.0f, (float)Math.cos(y / 2.0));
        Quaternion qPitch = new Quaternion((float)Math.sin(x / 2.0), 0.0f, 0.0f, (float)Math.cos(x / 2.0));
        Quaternion qRoll = new Quaternion(0.0f, 0.0f, (float)Math.sin(z / 2.0), (float)Math.cos(z / 2.0));
        qYaw.func_195890_a(qRoll);
        qYaw.func_195890_a(qPitch);
        return qYaw;
    }

    public static Vector3d[] applyMatrixToVertices(TransformationMatrix matrix, Vector3d ... vertices) {
        if (matrix == null) {
            return vertices;
        }
        Vector3d[] ret = new Vector3d[vertices.length];
        for (int i = 0; i < ret.length; ++i) {
            Vector4f vec = new Vector4f((float)vertices[i].field_72450_a, (float)vertices[i].field_72448_b, (float)vertices[i].field_72449_c, 1.0f);
            matrix.transformPosition(vec);
            vec.func_229375_f_();
            ret[i] = new Vector3d((double)vec.func_195910_a(), (double)vec.func_195913_b(), (double)vec.func_195914_c());
        }
        return ret;
    }

    public static Vector4f pulseRGBAlpha(Vector4f rgba, int tickrate, float min, float max) {
        float f_alpha = (float)(ClientUtils.mc().field_71439_g.field_70173_aa % (tickrate * 2)) / (float)tickrate;
        if (f_alpha > 1.0f) {
            f_alpha = 2.0f - f_alpha;
        }
        return new Vector4f(rgba.func_195910_a(), rgba.func_195913_b(), rgba.func_195914_c(), MathHelper.func_76131_a((float)f_alpha, (float)min, (float)max));
    }

    public static int findOffset(VertexFormat vf, VertexFormatElement.Usage u, VertexFormatElement.Type t) {
        int offset = 0;
        for (VertexFormatElement element : vf.func_227894_c_()) {
            if (element.func_177375_c() == u && element.func_177367_b() == t) {
                Preconditions.checkState((offset % 4 == 0 ? 1 : 0) != 0);
                return offset / 4;
            }
            offset += element.func_177368_f();
        }
        throw new IllegalStateException();
    }

    public static int findTextureOffset(VertexFormat vf) {
        return ClientUtils.findOffset(vf, VertexFormatElement.Usage.UV, VertexFormatElement.Type.FLOAT);
    }

    public static int findPositionOffset(VertexFormat vf) {
        return ClientUtils.findOffset(vf, VertexFormatElement.Usage.POSITION, VertexFormatElement.Type.FLOAT);
    }

    public static TransformationMatrix rotateTo(Direction d) {
        return ClientUtils.composeFixed(new TransformationMatrix(null).blockCornerToCenter(), ClientUtils.toModelRotation(d).func_225615_b_()).blockCenterToCorner();
    }

    public static TransformationMatrix composeFixed(TransformationMatrix _this, TransformationMatrix arg) {
        if (_this.isIdentity()) {
            return arg;
        }
        if (arg.isIdentity()) {
            return _this;
        }
        Matrix4f m = _this.func_227988_c_();
        m.func_226595_a_(arg.func_227988_c_());
        return new TransformationMatrix(m);
    }

    public static ModelRotation toModelRotation(Direction d) {
        switch (d) {
            case DOWN: {
                return ModelRotation.X90_Y0;
            }
            case UP: {
                return ModelRotation.X270_Y0;
            }
            case NORTH: {
                return ModelRotation.X0_Y0;
            }
            case SOUTH: {
                return ModelRotation.X0_Y180;
            }
            case WEST: {
                return ModelRotation.X0_Y270;
            }
            case EAST: {
                return ModelRotation.X0_Y90;
            }
        }
        throw new IllegalArgumentException(String.valueOf(d));
    }
}

