/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.energy.ThermoelectricHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.client.manual.IEManualInstance;
import blusunrize.immersiveengineering.client.manual.ManualElementBlueprint;
import blusunrize.immersiveengineering.client.manual.ManualElementMultiblock;
import blusunrize.immersiveengineering.client.manual.ShaderManualElement;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.lib.manual.ManualElementItem;
import blusunrize.lib.manual.ManualElementTable;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.TextSplitter;
import blusunrize.lib.manual.Tree;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class IEManual {
    public static void initManual() {
        IEManualInstance ieMan = new IEManualInstance();
        ManualHelper.IE_MANUAL_INSTANCE.setValue(ieMan);
        ManualHelper.ADD_CONFIG_GETTER.setValue(e -> {
            List<Function<String, Object>> list = ieMan.configGetters;
            synchronized (list) {
                ieMan.configGetters.add((Function<String, Object>)e);
            }
        });
        ieMan.registerSpecialElement(new ResourceLocation("immersiveengineering", "blueprint"), s -> {
            ItemStack[] stacks;
            if (JSONUtils.func_151202_d((JsonObject)s, (String)"recipes")) {
                JsonArray arr = s.get("recipes").getAsJsonArray();
                stacks = new ItemStack[arr.size()];
                for (int i = 0; i < stacks.length; ++i) {
                    stacks[i] = CraftingHelper.getItemStack((JsonObject)arr.get(i).getAsJsonObject(), (boolean)true);
                }
            } else {
                JsonElement recipe = s.get("recipe");
                Preconditions.checkArgument((boolean)recipe.isJsonObject());
                stacks = new ItemStack[]{CraftingHelper.getItemStack((JsonObject)recipe.getAsJsonObject(), (boolean)true)};
            }
            return new ManualElementBlueprint(ieMan, stacks);
        });
        ieMan.registerSpecialElement(new ResourceLocation("immersiveengineering", "multiblock"), s -> {
            ResourceLocation name = ManualUtils.getLocationForManual(JSONUtils.func_151200_h((JsonObject)s, (String)"name"), ieMan);
            MultiblockHandler.IMultiblock mb = MultiblockHandler.getByUniqueName(name);
            if (mb == null) {
                throw new NullPointerException("Multiblock " + name + " does not exist");
            }
            return new ManualElementMultiblock(ieMan, mb);
        });
    }

    public static void addIEManualEntries() {
        IEManualInstance ieMan = (IEManualInstance)ManualHelper.getManual();
        Tree.InnerNode<ResourceLocation, ManualEntry> generalCat = ieMan.getRoot().getOrCreateSubnode(new ResourceLocation("immersiveengineering", ManualHelper.CAT_GENERAL), 0);
        Tree.InnerNode<ResourceLocation, ManualEntry> energyCat = ieMan.getRoot().getOrCreateSubnode(new ResourceLocation("immersiveengineering", ManualHelper.CAT_ENERGY), 20);
        Tree.InnerNode<ResourceLocation, ManualEntry> heavyMachinesCat = ieMan.getRoot().getOrCreateSubnode(new ResourceLocation("immersiveengineering", ManualHelper.CAT_HEAVYMACHINES), 50);
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder.addSpecialElement("values", 0, IEManual.addDynamicTable(() -> ThermoelectricHandler.getThermalValuesSorted(true), "K"));
        builder.readFromFile(new ResourceLocation("immersiveengineering", "thermoelectric"));
        ieMan.addEntry(energyCat, builder.create(), ieMan.atOffsetFrom(energyCat, "redstone_wire", 0.5));
        builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder.readFromFile(new ResourceLocation("immersiveengineering", "minerals"));
        builder.appendText(IEManual::getMineralVeinTexts);
        ieMan.addEntry(generalCat, builder.create(), ieMan.atOffsetFrom(generalCat, "ores", 0.5));
        ResourceLocation blueprints = new ResourceLocation("immersiveengineering", "blueprints");
        ieMan.addEntry(generalCat, blueprints);
        ieMan.hideEntry(blueprints);
        ManualEntry.ManualEntryBuilder builder2 = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder2.addSpecialElement("list", 0, IEManual.addDynamicTable(() -> FermenterRecipe.getFluidValuesSorted((Fluid)IEContent.fluidEthanol, true), "mB"));
        builder2.readFromFile(new ResourceLocation("immersiveengineering", "fermenter"));
        ieMan.addEntry(heavyMachinesCat, builder2.create(), ieMan.atOffsetFrom(heavyMachinesCat, "assembler", 0.3333333333333333));
        builder2 = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder2.addSpecialElement("list", 0, IEManual.addDynamicTable(() -> SqueezerRecipe.getFluidValuesSorted((Fluid)IEContent.fluidPlantoil, true), "mB"));
        builder2.readFromFile(new ResourceLocation("immersiveengineering", "squeezer"));
        ieMan.addEntry(heavyMachinesCat, builder2.create(), ieMan.atOffsetFrom(heavyMachinesCat, "assembler", 0.6666666666666666));
        builder2 = new ManualEntry.ManualEntryBuilder(ieMan);
        builder2.setContent(() -> "Shader list", () -> "", () -> {
            StringBuilder content = new StringBuilder();
            for (ShaderRegistry.ShaderRegistryEntry shader : ShaderRegistry.shaderRegistry.values()) {
                String key = shader.name.func_110623_a();
                content.append("<&").append(key).append(">").append("<np>");
            }
            int last = content.lastIndexOf("<np>");
            content.delete(last, last + 4);
            return content.toString();
        });
        for (ShaderRegistry.ShaderRegistryEntry shader : ShaderRegistry.shaderRegistry.values()) {
            String key = shader.name.func_110623_a();
            builder2.addSpecialElement(key, 0, new ShaderManualElement(ieMan, shader));
        }
        builder2.setLocation(new ResourceLocation("immersiveengineering", "shader_list"));
        ManualEntry e = builder2.create();
        ieMan.addEntry(generalCat, e);
        ieMan.hideEntry(e.getLocation());
        IEManual.addChangelogToManual();
    }

    private static Supplier<ManualElementTable> addDynamicTable(Supplier<SortedMap<ITextComponent, Integer>> getContents, String valueType) {
        return () -> {
            ITextComponent[][] table = IEManual.formatToTable_ItemIntMap((Map)getContents.get(), valueType);
            return new ManualElementTable(ManualHelper.getManual(), table, false);
        };
    }

    private static String getMineralVeinTexts(TextSplitter splitter) {
        StringBuilder text = new StringBuilder();
        ArrayList<MineralMix> mineralsToAdd = new ArrayList<MineralMix>(MineralMix.mineralList.values());
        Function<MineralMix, String> toName = mineral -> {
            String translationKey = mineral.getTranslationKey();
            String localizedName = I18n.func_135052_a((String)translationKey, (Object[])new Object[0]);
            if (localizedName.equals(translationKey)) {
                localizedName = mineral.getPlainName();
            }
            return localizedName;
        };
        mineralsToAdd.sort((i1, i2) -> ((String)toName.apply((MineralMix)i1)).compareToIgnoreCase((String)toName.apply((MineralMix)i2)));
        for (MineralMix mineral2 : mineralsToAdd) {
            String dimensionString;
            if (mineral2.dimensions != null && mineral2.dimensions.size() > 0) {
                StringBuilder validDims = new StringBuilder();
                for (RegistryKey dim : mineral2.dimensions) {
                    validDims.append(validDims.length() > 0 ? ", " : "").append("<dim;").append(dim.func_240901_a_()).append(">");
                }
                dimensionString = I18n.func_135052_a((String)"ie.manual.entry.mineralsDimValid", (Object[])new Object[]{toName.apply(mineral2), validDims.toString()});
            } else {
                dimensionString = I18n.func_135052_a((String)"ie.manual.entry.mineralsDimAny", (Object[])new Object[]{toName.apply(mineral2)});
            }
            List<StackWithChance> formattedOutputs = Arrays.asList(mineral2.outputs);
            formattedOutputs.sort(Comparator.comparingDouble(i -> -i.getChance()));
            StringBuilder outputString = new StringBuilder();
            NonNullList sortedOres = NonNullList.func_191196_a();
            for (StackWithChance sorted : formattedOutputs) {
                outputString.append("\n").append(new DecimalFormat("00.00").format(sorted.getChance() * 100.0f).replaceAll("\\G0", "\u00a0")).append("% ").append(sorted.getStack().func_200301_q().getString());
                sortedOres.add((Object)sorted.getStack());
            }
            splitter.addSpecialPage(mineral2.func_199560_c().toString(), 0, new ManualElementItem(ManualHelper.getManual(), (NonNullList<ItemStack>)sortedOres));
            String desc = I18n.func_135052_a((String)"ie.manual.entry.minerals_desc", (Object[])new Object[]{dimensionString, outputString.toString()});
            if (text.length() > 0) {
                text.append("<np>");
            }
            text.append("<&").append(mineral2.func_199560_c()).append(">").append(desc);
        }
        return text.toString();
    }

    private static void addChangelogToManual() {
        TreeMap allChanges = new TreeMap(Comparator.reverseOrder());
        ComparableVersion currIEVer = new ComparableVersion("${version}");
        try (InputStream in = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation("immersiveengineering", "changelog.json")).func_199027_b();){
            JsonElement ele = new JsonParser().parse((Reader)new InputStreamReader(in));
            JsonObject jsonObject = ele.getAsJsonObject();
            for (Object entry : jsonObject.entrySet()) {
                ComparableVersion version = new ComparableVersion((String)entry.getKey());
                ManualEntry manualEntry = IEManual.addVersionToManual(currIEVer, version, ((JsonElement)entry.getValue()).getAsString(), false);
                if (manualEntry == null) continue;
                allChanges.put(version, manualEntry);
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)ModLoadingContext.get().getActiveContainer().getModInfo());
        if (result.status != VersionChecker.Status.PENDING && result.status != VersionChecker.Status.FAILED) {
            for (Map.Entry entry : result.changes.entrySet()) {
                if (allChanges.containsKey(entry.getKey())) continue;
                allChanges.put((ComparableVersion)entry.getKey(), IEManual.addVersionToManual(currIEVer, (ComparableVersion)entry.getKey(), (String)entry.getValue(), true));
            }
        }
        ManualInstance ieMan = ManualHelper.getManual();
        Tree.InnerNode<ResourceLocation, ManualEntry> innerNode = ieMan.getRoot().getOrCreateSubnode(new ResourceLocation("immersiveengineering", ManualHelper.CAT_UPDATE), -2);
        for (Object entry : allChanges.values()) {
            ManualHelper.getManual().addEntry(innerNode, (ManualEntry)entry);
        }
    }

    private static ManualEntry addVersionToManual(ComparableVersion currVer, ComparableVersion version, String changes, boolean ahead) {
        String text = changes.replace("\t", "  ");
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder.setContent(() -> {
            String title = version.toString();
            if (ahead) {
                title = title + " - " + I18n.func_135052_a((String)"ie.manual.newerVersion", (Object[])new Object[0]);
            } else if (currVer.equals((Object)version)) {
                title = title + " - " + I18n.func_135052_a((String)"ie.manual.currentVersion", (Object[])new Object[0]);
            }
            return title;
        }, () -> "", () -> text);
        builder.setLocation(new ResourceLocation("immersiveengineering", "changelog_" + version.toString()));
        return builder.create();
    }

    static <T> ITextComponent[][] formatToTable_ItemIntMap(Map<T, Integer> map, String valueType) {
        ArrayList<Map.Entry<T, Integer>> sortedMapArray = new ArrayList<Map.Entry<T, Integer>>(map.entrySet());
        sortedMapArray.sort(Map.Entry.comparingByValue());
        ArrayList<ITextComponent[]> list = new ArrayList<ITextComponent[]>();
        try {
            for (Map.Entry entry : sortedMapArray) {
                ItemStack is;
                ResourceLocation key;
                ITextComponent item = null;
                if (entry.getKey() instanceof ITextComponent) {
                    item = (ITextComponent)entry.getKey();
                } else if (entry.getKey() instanceof ResourceLocation && TagUtils.isNonemptyItemTag(key = (ResourceLocation)entry.getKey()) && !(is = IEApi.getPreferredTagStack(key)).func_190926_b()) {
                    item = is.func_200301_q();
                }
                if (item == null) {
                    item = ITextComponent.func_244388_a((String)entry.getKey().toString());
                }
                int bt = (Integer)entry.getValue();
                ITextComponent am = ITextComponent.func_244388_a((String)(bt + " " + valueType));
                list.add(new ITextComponent[]{item, am});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (ITextComponent[][])list.toArray((T[])new ITextComponent[0][]);
    }
}

