/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DropConveyor
extends BasicConveyor {
    public static final ResourceLocation NAME = new ResourceLocation("immersiveengineering", "dropper");
    private static final VoxelShape REQUIRED_SPACE = VoxelShapes.func_197873_a((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
    private VoxelShape cachedDownShape = VoxelShapes.func_197880_a();
    private boolean cachedOpenBelow = true;
    public static ResourceLocation texture_on = new ResourceLocation("immersiveengineering:block/conveyor/dropper");
    public static ResourceLocation texture_off = new ResourceLocation("immersiveengineering:block/conveyor/dropper_off");

    public DropConveyor(TileEntity tile) {
        super(tile);
    }

    @Override
    public void handleInsertion(ItemEntity entity, ConveyorHandler.ConveyorDirection conDir, double distX, double distZ) {
        if (!this.isPowered()) {
            BlockPos posDown = this.getTile().func_174877_v().func_177977_b();
            TileEntity inventoryTile = this.getTile().func_145831_w().func_175625_s(posDown);
            boolean contact = Math.abs(this.getFacing().func_176740_k() == Direction.Axis.Z ? (double)this.getTile().func_174877_v().func_177952_p() + 0.5 - entity.func_226281_cx_() : (double)this.getTile().func_174877_v().func_177958_n() + 0.5 - entity.func_226277_ct_()) < 0.2;
            LazyOptional<IItemHandler> cap = LazyOptional.empty();
            if (contact && !(inventoryTile instanceof ConveyorHandler.IConveyorTile)) {
                cap = CapabilityUtils.findItemHandlerAtPos(this.getTile().func_145831_w(), posDown, Direction.UP, true);
            }
            if (cap.isPresent()) {
                cap.ifPresent(itemHandler -> {
                    ItemStack stack = entity.func_92059_d();
                    ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack.func_77946_l(), (boolean)true);
                    if (temp.func_190926_b() || temp.func_190916_E() < stack.func_190916_E()) {
                        temp = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                        if (temp.func_190926_b()) {
                            entity.func_70106_y();
                        } else if (temp.func_190916_E() < stack.func_190916_E()) {
                            entity.func_92058_a(temp);
                        }
                    }
                });
            } else if (contact && this.isEmptySpace(this.getTile().func_145831_w(), posDown, inventoryTile)) {
                entity.func_213293_j(0.0, entity.func_213322_ci().field_72448_b, 0.0);
                entity.func_70107_b((double)this.getTile().func_174877_v().func_177958_n() + 0.5, (double)this.getTile().func_174877_v().func_177956_o() - 0.5, (double)this.getTile().func_174877_v().func_177952_p() + 0.5);
                if (!(inventoryTile instanceof ConveyorHandler.IConveyorTile)) {
                    ConveyorHandler.revertMagnetSuppression((Entity)entity, (ConveyorHandler.IConveyorTile)this.getTile());
                }
            } else {
                super.handleInsertion(entity, conDir, distX, distZ);
            }
        } else {
            super.handleInsertion(entity, conDir, distX, distZ);
        }
    }

    boolean isEmptySpace(World world, BlockPos pos, TileEntity tile) {
        if (tile instanceof ConveyorHandler.IConveyorTile) {
            return true;
        }
        BlockState state = world.func_180495_p(pos);
        VoxelShape shape = state.func_196952_d((IBlockReader)world, pos);
        if (shape != this.cachedDownShape) {
            this.cachedOpenBelow = !VoxelShapes.func_197879_c((VoxelShape)REQUIRED_SPACE, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223238_i_);
            this.cachedDownShape = shape;
        }
        return this.cachedOpenBelow;
    }

    @Override
    public ResourceLocation getActiveTexture() {
        return texture_on;
    }

    @Override
    public ResourceLocation getInactiveTexture() {
        return texture_off;
    }
}

