/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.common.blocks.BlockItemIE;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ToolType;

public class SawdustBlock
extends IEBaseBlock {
    protected static final int MAX_LAYER = 9;
    public static final IntegerProperty LAYERS = IntegerProperty.func_177719_a((String)"layers", (int)1, (int)9);
    protected static final CachedVoxelShapes<Integer> SHAPES = new CachedVoxelShapes<Integer>(layer -> {
        if (layer == 0) {
            return null;
        }
        if (layer == 9) {
            return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        }
        return ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625 + 0.125 * (double)(layer - 1), 1.0));
    });

    public SawdustBlock() {
        super("sawdust", AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151658_d).func_200947_a(SoundType.field_185855_h).harvestTool(ToolType.SHOVEL).func_200943_b(0.5f).func_200942_a().func_226896_b_(), BlockItemIE::new);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{LAYERS});
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 60;
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        if (type == PathType.LAND) {
            return (Integer)state.func_177229_b((Property)LAYERS) < 5;
        }
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get((Integer)state.func_177229_b((Property)LAYERS));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get((Integer)state.func_177229_b((Property)LAYERS) - 1);
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = blockstate.func_177230_c();
        return Block.func_208061_a((VoxelShape)blockstate.func_196952_d((IBlockReader)worldIn, pos.func_177977_b()), (Direction)Direction.UP) || block == this && (Integer)blockstate.func_177229_b((Property)LAYERS) == 9;
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        int i = (Integer)state.func_177229_b((Property)LAYERS);
        if (useContext.func_195996_i().func_77973_b() == this.func_199767_j() && i < 9) {
            if (useContext.func_196012_c()) {
                return useContext.func_196000_l() == Direction.UP;
            }
            return true;
        }
        return i == 1;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (blockstate.func_177230_c() == this) {
            return (BlockState)blockstate.func_206870_a((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(9, (Integer)blockstate.func_177229_b((Property)LAYERS) + 1)));
        }
        return super.func_196258_a(context);
    }
}

