/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.crafting.GeneratedListRecipe;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class GeneratedListSerializer
extends IERecipeSerializer<GeneratedListRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IEItems.Misc.wireCoils.get(WireType.COPPER));
    }

    @Override
    public GeneratedListRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        return new GeneratedListRecipe(recipeId);
    }

    @Nullable
    public GeneratedListRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        int length = buffer.func_150792_a();
        ArrayList<IESerializableRecipe> subRecipes = new ArrayList<IESerializableRecipe>(length);
        ResourceLocation recipeCategory = buffer.func_192575_l();
        IRecipeSerializer deserializer = RecipeSerializers.RECIPE_SERIALIZERS.getEntries().stream().map(RegistryObject::get).filter(ser -> recipeCategory.equals((Object)ser.getRegistryName())).findAny().orElseThrow(RuntimeException::new);
        for (int i = 0; i < length; ++i) {
            ResourceLocation recipeName = buffer.func_192575_l();
            IRecipe subRecipe = deserializer.func_199426_a_(recipeName, buffer);
            subRecipes.add((IESerializableRecipe)subRecipe);
        }
        return new GeneratedListRecipe(recipeId, subRecipes);
    }

    public void toNetwork(@Nonnull PacketBuffer buffer, @Nonnull GeneratedListRecipe recipe) {
        List<? extends IESerializableRecipe> recipes = recipe.getSubRecipes();
        buffer.func_150787_b(recipes.size());
        buffer.func_192572_a(recipe.getSubSerializer());
        for (IESerializableRecipe iESerializableRecipe : recipes) {
            buffer.func_192572_a(iESerializableRecipe.func_199560_c());
            ((IERecipeSerializer)iESerializableRecipe.func_199559_b()).func_199427_a_(buffer, iESerializableRecipe);
        }
    }
}

