/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.common.crafting.fluidaware.TurnAndCopyRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TurnAndCopyRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<TurnAndCopyRecipe> {
    @Nonnull
    public TurnAndCopyRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        ShapedRecipe basic = (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(recipeId, json);
        TurnAndCopyRecipe recipe = new TurnAndCopyRecipe(recipeId, basic.func_193358_e(), basic.func_192403_f(), basic.func_192404_g(), (NonNullList<Ingredient>)basic.func_192400_c(), basic.func_77571_b());
        if (JSONUtils.func_151209_a((JsonObject)json, (String)"quarter_turn", (boolean)false)) {
            recipe.allowQuarterTurn();
        }
        if (JSONUtils.func_151209_a((JsonObject)json, (String)"eighth_turn", (boolean)false)) {
            recipe.allowEighthTurn();
        }
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"copy_nbt")) {
            if (JSONUtils.func_151202_d((JsonObject)json, (String)"copy_nbt")) {
                JsonArray jArray = JSONUtils.func_151214_t((JsonObject)json, (String)"copy_nbt");
                int[] array = new int[jArray.size()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = jArray.get(i).getAsInt();
                }
                recipe.setNBTCopyTargetRecipe(array);
            } else {
                recipe.setNBTCopyTargetRecipe(JSONUtils.func_151203_m((JsonObject)json, (String)"copy_nbt"));
            }
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"copy_nbt_predicate")) {
                recipe.setNBTCopyPredicate(JSONUtils.func_151200_h((JsonObject)json, (String)"copy_nbt_predicate"));
            }
        }
        return recipe;
    }

    @Nonnull
    public TurnAndCopyRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        int[] array;
        ShapedRecipe basic = (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199426_a_(recipeId, buffer);
        TurnAndCopyRecipe recipe = new TurnAndCopyRecipe(recipeId, basic.func_193358_e(), basic.func_192403_f(), basic.func_192404_g(), (NonNullList<Ingredient>)basic.func_192400_c(), basic.func_77571_b());
        if (buffer.readBoolean()) {
            recipe.allowQuarterTurn();
        }
        if (buffer.readBoolean()) {
            recipe.allowEighthTurn();
        }
        if ((array = buffer.func_186863_b()).length > 0) {
            recipe.setNBTCopyTargetRecipe(array);
            if (buffer.readBoolean()) {
                recipe.setNBTCopyPredicate(buffer.func_150789_c(512));
            }
        }
        return recipe;
    }

    public void toNetwork(@Nonnull PacketBuffer buffer, @Nonnull TurnAndCopyRecipe recipe) {
        IRecipeSerializer.field_222157_a.func_199427_a_(buffer, (IRecipe)recipe.toVanilla());
        buffer.writeBoolean(recipe.isQuarterTurn());
        buffer.writeBoolean(recipe.isEightTurn());
        int[] copying = recipe.getCopyTargets();
        if (copying == null) {
            copying = new int[]{};
        }
        buffer.func_186875_a(copying);
        if (copying.length > 0) {
            if (recipe.hasCopyPredicate()) {
                buffer.writeBoolean(true);
                buffer.func_180714_a(recipe.getBufferPredicate());
            } else {
                buffer.writeBoolean(false);
            }
        }
    }
}

