/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class DrillheadItem
extends IEBaseItem
implements IDrillHead {
    public static final DrillHeadPerm STEEL = new DrillHeadPerm("steel", (ITag<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot, 3, 1, 3, 10.0f, 7, 10000, new ResourceLocation("immersiveengineering", "item/drill_diesel"));
    public static final DrillHeadPerm IRON = new DrillHeadPerm("iron", (ITag<Item>)Tags.Items.INGOTS_IRON, 2, 1, 2, 9.0f, 6, 6000, new ResourceLocation("immersiveengineering", "item/drill_iron"));
    public static final String DAMAGE_KEY_OLD = "headDamage";
    public static final String DAMAGE_KEY = "Damage";
    public DrillHeadPerm perms;

    public DrillheadItem(DrillHeadPerm perms) {
        super("drillhead_" + perms.name, new Item.Properties().func_200917_a(1));
        this.perms = perms;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.drillhead.size", new Object[]{this.perms.drillSize, this.perms.drillDepth}));
        list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.drillhead.level", new Object[]{Utils.getHarvestLevelName(this.getMiningLevel(stack))}));
        list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.drillhead.speed", new Object[]{Utils.formatDouble(this.getMiningSpeed(stack), "0.###")}));
        list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.drillhead.damage", new Object[]{Utils.formatDouble(this.getAttackDamage(stack), "0.###")}));
        int maxDmg = this.getMaximumHeadDamage(stack);
        int dmg = maxDmg - this.getHeadDamage(stack);
        float quote = (float)dmg / (float)maxDmg;
        String status = "" + ((double)quote < 0.1 ? TextFormatting.RED : ((double)quote < 0.3 ? TextFormatting.GOLD : ((double)quote < 0.6 ? TextFormatting.YELLOW : TextFormatting.GREEN)));
        String s = status + (this.getMaximumHeadDamage(stack) - this.getHeadDamage(stack)) + "/" + this.getMaximumHeadDamage(stack);
        list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.durability", new Object[]{s}));
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return this.perms.repairMaterial.func_230235_a_((Object)material.func_77973_b());
    }

    @Override
    public boolean beforeBlockbreak(ItemStack drill, ItemStack head, PlayerEntity player) {
        return false;
    }

    @Override
    public void afterBlockbreak(ItemStack drill, ItemStack head, PlayerEntity player) {
    }

    @Override
    public int getMiningLevel(ItemStack head) {
        return this.perms.drillLevel;
    }

    @Override
    public float getMiningSpeed(ItemStack head) {
        return this.perms.drillSpeed;
    }

    @Override
    public float getAttackDamage(ItemStack head) {
        return this.perms.drillAttack;
    }

    @Override
    public int getHeadDamage(ItemStack head) {
        if (head.func_77942_o()) {
            CompoundNBT nbt = head.func_196082_o();
            if (nbt.func_150297_b(DAMAGE_KEY_OLD, 3)) {
                return nbt.func_74762_e(DAMAGE_KEY_OLD);
            }
            return nbt.func_74762_e(DAMAGE_KEY);
        }
        return 0;
    }

    @Override
    public int getMaximumHeadDamage(ItemStack head) {
        return this.perms.maxDamage;
    }

    @Override
    public void damageHead(ItemStack head, int dmg) {
        DrillheadItem.setHeadDamage(head, this.getHeadDamage(head) + dmg);
    }

    public static void setHeadDamage(ItemStack head, int totalDamage) {
        CompoundNBT nbt = head.func_196082_o();
        nbt.func_82580_o(DAMAGE_KEY_OLD);
        nbt.func_74768_a(DAMAGE_KEY, totalDamage);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getDrillTexture(ItemStack drill, ItemStack head) {
        return this.perms.sprite;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getHeadDamage(stack) / (double)this.getMaximumHeadDamage(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getHeadDamage(stack) > 0;
    }

    @Override
    public ImmutableList<BlockPos> getExtraBlocksDug(ItemStack head, World world, PlayerEntity player, RayTraceResult rtr) {
        if (!(rtr instanceof BlockRayTraceResult)) {
            return ImmutableList.of();
        }
        BlockRayTraceResult brtr = (BlockRayTraceResult)rtr;
        Direction side = brtr.func_216354_b();
        int diameter = this.perms.drillSize;
        int depth = this.perms.drillDepth;
        BlockPos startPos = brtr.func_216350_a();
        BlockState state = world.func_180495_p(startPos);
        Block block = state.func_177230_c();
        float maxHardness = 1.0f;
        if (block != null && !block.isAir(state, (IBlockReader)world, startPos)) {
            maxHardness = state.func_185903_a(player, (IBlockReader)world, startPos) * 0.6f;
        }
        if (maxHardness < 0.0f) {
            maxHardness = 0.0f;
        }
        if (diameter % 2 == 0) {
            float hx = (float)brtr.func_216347_e().field_72450_a - (float)brtr.func_216350_a().func_177958_n();
            float hy = (float)brtr.func_216347_e().field_72448_b - (float)brtr.func_216350_a().func_177956_o();
            float hz = (float)brtr.func_216347_e().field_72449_c - (float)brtr.func_216350_a().func_177952_p();
            if (side.func_176740_k() == Direction.Axis.Y && (double)hx < 0.5 || side.func_176740_k() == Direction.Axis.Z && (double)hx < 0.5) {
                startPos = startPos.func_177982_a(-diameter / 2, 0, 0);
            }
            if (side.func_176740_k() != Direction.Axis.Y && (double)hy < 0.5) {
                startPos = startPos.func_177982_a(0, -diameter / 2, 0);
            }
            if (side.func_176740_k() == Direction.Axis.Y && (double)hz < 0.5 || side.func_176740_k() == Direction.Axis.X && (double)hz < 0.5) {
                startPos = startPos.func_177982_a(0, 0, -diameter / 2);
            }
        } else {
            startPos = startPos.func_177982_a(-(side.func_176740_k() == Direction.Axis.X ? 0 : diameter / 2), -(side.func_176740_k() == Direction.Axis.Y ? 0 : diameter / 2), -(side.func_176740_k() == Direction.Axis.Z ? 0 : diameter / 2));
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (int dd = 0; dd < depth; ++dd) {
            for (int dw = 0; dw < diameter; ++dw) {
                for (int dh = 0; dh < diameter; ++dh) {
                    boolean hardness;
                    BlockPos pos = startPos.func_177982_a(side.func_176740_k() == Direction.Axis.X ? dd : dw, side.func_176740_k() == Direction.Axis.Y ? dd : dh, side.func_176740_k() == Direction.Axis.Y ? dh : (side.func_176740_k() == Direction.Axis.X ? dw : dd));
                    if (pos.equals((Object)brtr.func_216350_a())) continue;
                    state = world.func_180495_p(pos);
                    block = state.func_177230_c();
                    float h = state.func_185903_a(player, (IBlockReader)world, pos);
                    boolean canHarvest = block.canHarvestBlock(world.func_180495_p(pos), (IBlockReader)world, pos, player);
                    boolean drillMat = ((DrillItem)IEItems.Tools.drill).isEffective(ItemStack.field_190927_a, state.func_185904_a());
                    boolean bl = hardness = h > maxHardness;
                    if (!canHarvest || !drillMat || !hardness) continue;
                    b.add((Object)pos);
                }
            }
        }
        return b.build();
    }

    public static class DrillHeadPerm {
        public static final Set<DrillHeadPerm> ALL_PERMS = new HashSet<DrillHeadPerm>();
        final String name;
        final ITag<Item> repairMaterial;
        final int drillSize;
        final int drillDepth;
        final int drillLevel;
        final float drillSpeed;
        final float drillAttack;
        final int maxDamage;
        public final ResourceLocation texture;
        @OnlyIn(value=Dist.CLIENT)
        public TextureAtlasSprite sprite;

        public DrillHeadPerm(String name, ITag<Item> repairMaterial, int drillSize, int drillDepth, int drillLevel, float drillSpeed, int drillAttack, int maxDamage, ResourceLocation texture) {
            this.name = name;
            this.repairMaterial = repairMaterial;
            this.drillSize = drillSize;
            this.drillDepth = drillDepth;
            this.drillLevel = drillLevel;
            this.drillSpeed = drillSpeed;
            this.drillAttack = drillAttack;
            this.maxDamage = maxDamage;
            this.texture = texture;
            ALL_PERMS.add(this);
        }
    }
}

