/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.network.IMessage;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MessageClientCommand
implements IMessage {
    private final Type type;

    public MessageClientCommand(Type type) {
        this.type = type;
    }

    public MessageClientCommand(PacketBuffer buf) {
        this(Type.values()[buf.func_150792_a()]);
    }

    public static void send(CommandContext<CommandSource> context, Type type) throws CommandSyntaxException {
        CommandSource source = (CommandSource)context.getSource();
        source.func_197027_g();
        ServerPlayerEntity entity = source.func_197035_h();
        ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> entity), (Object)new MessageClientCommand(type));
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_150787_b(this.type.ordinal());
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(this.type.run);
    }

    public static enum Type {
        RESET_MANUAL(ImmersiveEngineering.proxy::resetManual),
        RESET_SHADER_CACHES(ImmersiveEngineering.proxy::clearRenderCaches);

        private final Runnable run;

        private Type(Runnable run) {
            this.run = run;
        }
    }
}

