/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FakePlayerUtil {
    private static GameProfile IE_PROFILE = new GameProfile(UUID.fromString("99562b85-bd1a-4ded-bb1a-c307bf0c0133"), "[ImmersiveEngineering]");
    private static Map<IWorld, FakePlayer> fakePlayerInstances = new HashMap<IWorld, FakePlayer>();

    public static FakePlayer getFakePlayer(World world) {
        return fakePlayerInstances.computeIfAbsent((IWorld)world, w -> {
            if (w instanceof ServerWorld) {
                return FakePlayerFactory.get((ServerWorld)((ServerWorld)w), (GameProfile)IE_PROFILE);
            }
            return null;
        });
    }

    @SubscribeEvent
    public static void onUnload(WorldEvent.Unload ev) {
        IWorld world = ev.getWorld();
        if (world instanceof ServerWorld) {
            fakePlayerInstances.remove(world);
        }
    }
}

