/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.item.MCWeightedItemStack;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.MCTagWithAmount;
import com.google.common.base.Preconditions;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;

public class CrTIngredientUtil {
    private CrTIngredientUtil() {
    }

    public static IngredientWithSize getIngredientWithSize(IIngredientWithAmount crafttweakerIngredient) {
        Ingredient basePredicate = crafttweakerIngredient.getIngredient().asVanillaIngredient();
        return new IngredientWithSize(basePredicate, crafttweakerIngredient.getAmount());
    }

    public static IngredientWithSize[] getIngredientsWithSize(IIngredientWithAmount[] crafttweakerIngredients) {
        IngredientWithSize[] result = new IngredientWithSize[crafttweakerIngredients.length];
        for (int i = 0; i < crafttweakerIngredients.length; ++i) {
            result[i] = new IngredientWithSize(crafttweakerIngredients[i].getIngredient().asVanillaIngredient(), crafttweakerIngredients[i].getAmount());
        }
        return result;
    }

    public static NonNullList<ItemStack> getNonNullList(IItemStack[] itemStacks) {
        NonNullList result = NonNullList.func_191196_a();
        for (IItemStack itemStack : itemStacks) {
            result.add((Object)itemStack.getInternal());
        }
        return result;
    }

    public static StackWithChance getStackWithChance(MCWeightedItemStack weightedStack) {
        ItemStack stack = weightedStack.getItemStack().getInternal();
        float weight = MathHelper.func_76131_a((float)((float)weightedStack.getWeight()), (float)0.0f, (float)1.0f);
        return new StackWithChance(stack, weight);
    }

    public static FluidTagInput getFluidTagInput(MCTag<Fluid> tag, int amount) {
        ITag internal = tag.getInternal();
        Preconditions.checkNotNull((Object)internal, (Object)("Invalid fluid tag used for recipe: " + tag.toString()));
        return new FluidTagInput((ITag<Fluid>)internal, amount, null);
    }

    public static FluidTagInput getFluidTagInput(MCTagWithAmount<Fluid> tag) {
        ITag internal = tag.getTag().getInternal();
        Preconditions.checkNotNull((Object)internal, (Object)("Invalid fluid tag used for recipe: " + tag.toString()));
        return new FluidTagInput((ITag<Fluid>)internal, tag.getAmount(), null);
    }
}

