/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionGenericRemoveRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.ActionAddRecipeCustomOutput;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.MCTagWithAmount;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Refinery")
@ZenCodeType.Name(value="mods.immersiveengineering.Refinery")
public class RefineryRecipeManager
implements IRecipeManager {
    public IRecipeType<RefineryRecipe> getRecipeType() {
        return RefineryRecipe.TYPE;
    }

    public void removeRecipe(IItemStack output) {
        throw new UnsupportedOperationException("Cannot remove a refinery recipe by item output, since it only has a fluid output");
    }

    @ZenCodeType.Method
    public void removeRecipe(final IFluidStack fluidStack) {
        AbstractActionGenericRemoveRecipe<RefineryRecipe> action = new AbstractActionGenericRemoveRecipe<RefineryRecipe>((IRecipeManager)this, (CommandStringDisplayable)fluidStack){

            @Override
            public boolean shouldRemove(RefineryRecipe recipe) {
                return recipe.output.isFluidStackIdentical(fluidStack.getInternal());
            }
        };
        CraftTweakerAPI.apply((IAction)action);
    }

    @ZenCodeType.Method
    public void removeRecipe(final Fluid fluid) {
        AbstractActionGenericRemoveRecipe<RefineryRecipe> action = new AbstractActionGenericRemoveRecipe<RefineryRecipe>((IRecipeManager)this, fluid){

            @Override
            public boolean shouldRemove(RefineryRecipe recipe) {
                return fluid.func_207187_a(recipe.output.getFluid());
            }
        };
        CraftTweakerAPI.apply((IAction)action);
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, MCTagWithAmount<Fluid> fluidInput1, MCTagWithAmount<Fluid> fluidInput2, int energy, IFluidStack output) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        FluidStack outputStack = output.getInternal();
        FluidTagInput tagInput1 = CrTIngredientUtil.getFluidTagInput((MCTag<Fluid>)fluidInput1.getTag(), fluidInput1.getAmount());
        FluidTagInput tagInput2 = CrTIngredientUtil.getFluidTagInput((MCTag<Fluid>)fluidInput2.getTag(), fluidInput2.getAmount());
        RefineryRecipe recipe = new RefineryRecipe(resourceLocation, outputStack, tagInput1, tagInput2, energy);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipeCustomOutput((IRecipeManager)this, recipe, (CommandStringDisplayable)output));
    }
}

