/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.config;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public enum Upgrades {
    CAPACITY("item.appliedenergistics2.capacity_card", 0),
    REDSTONE("item.appliedenergistics2.redstone_card", 0),
    CRAFTING("item.appliedenergistics2.crafting_card", 0),
    FUZZY("item.appliedenergistics2.fuzzy_card", 1),
    SPEED("item.appliedenergistics2.speed_card", 1),
    INVERTER("item.appliedenergistics2.inverter_card", 1);

    private final int tier;
    private final ITextComponent displayName;
    private final List<Supported> supported = new ArrayList<Supported>();
    private List<ITextComponent> supportedTooltipLines;

    private Upgrades(String translationKey, int tier) {
        this.tier = tier;
        this.displayName = new TranslationTextComponent(translationKey);
    }

    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    public List<Supported> getSupported() {
        return this.supported;
    }

    public void registerItem(IItemProvider item, int maxSupported) {
        this.registerItem(item, maxSupported, null);
    }

    public void registerItem(IItemProvider item, int maxSupported, @Nullable String tooltipGroup) {
        Preconditions.checkNotNull((Object)item);
        this.supported.add(new Supported(item.func_199767_j(), maxSupported, tooltipGroup));
        this.supportedTooltipLines = null;
    }

    public List<ITextComponent> getTooltipLines() {
        if (this.supportedTooltipLines == null) {
            this.supported.sort(Comparator.comparingInt(o -> ((Supported)o).maxCount));
            this.supportedTooltipLines = new ArrayList<ITextComponent>(this.supported.size());
            HashSet<ITextComponent> namesAdded = new HashSet<ITextComponent>();
            for (int i = 0; i < this.supported.size(); ++i) {
                Supported supported = this.supported.get(i);
                ITextComponent name = supported.item.func_200296_o();
                if (supported.getTooltipGroup() != null && namesAdded.contains(supported.getTooltipGroup())) continue;
                if (supported.getTooltipGroup() != null) {
                    for (int j = i + 1; j < this.supported.size(); ++j) {
                        ITextComponent otherGroup = this.supported.get(j).getTooltipGroup();
                        if (!supported.getTooltipGroup().equals(otherGroup)) continue;
                        name = supported.getTooltipGroup();
                        break;
                    }
                }
                if (!namesAdded.add(name)) continue;
                if (supported.maxCount > 1) {
                    name = name.func_230532_e_().func_240702_b_(" (" + supported.maxCount + ")");
                }
                this.supportedTooltipLines.add(name);
            }
        }
        return this.supportedTooltipLines;
    }

    public int getTier() {
        return this.tier;
    }

    public static class Supported {
        private final Item item;
        private final Block block;
        private final int maxCount;
        @Nullable
        private final String tooltipGroup;

        public Supported(Item item, int maxCount, @Nullable String tooltipGroup) {
            this.item = item;
            this.block = item.getItem() instanceof BlockItem ? ((BlockItem)item.getItem()).func_179223_d() : null;
            this.maxCount = maxCount;
            this.tooltipGroup = tooltipGroup;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public boolean isSupported(Block block) {
            return block != null && this.block == block;
        }

        public boolean isSupported(Item item) {
            return item != null && this.item == item;
        }

        public ITextComponent getTooltipGroup() {
            return this.tooltipGroup != null ? new TranslationTextComponent(this.tooltipGroup) : null;
        }
    }
}

