/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.block.AEBaseTileBlock;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.VibrationChamberContainer;
import appeng.core.AEConfig;
import appeng.tile.misc.VibrationChamberTileEntity;
import appeng.util.InteractionUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public final class VibrationChamberBlock
extends AEBaseTileBlock<VibrationChamberTileEntity> {
    private static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

    public VibrationChamberBlock() {
        super(VibrationChamberBlock.defaultProps(Material.field_151573_f).func_200943_b(4.2f));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockState updateBlockStateFromTileEntity(BlockState currentState, VibrationChamberTileEntity te) {
        return (BlockState)currentState.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(te.isOn));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ACTIVE});
    }

    @Override
    public ActionResultType onActivated(World w, BlockPos pos, PlayerEntity player, Hand hand, @Nullable ItemStack heldItem, BlockRayTraceResult hit) {
        VibrationChamberTileEntity tc;
        if (InteractionUtil.isInAlternateUseMode(player)) {
            return ActionResultType.PASS;
        }
        if (!w.func_201670_d() && (tc = (VibrationChamberTileEntity)this.getTileEntity((IBlockReader)w, pos)) != null) {
            ContainerOpener.openContainer(VibrationChamberContainer.TYPE, player, ContainerLocator.forTileEntitySide(tc, hit.func_216354_b()));
        }
        return ActionResultType.func_233537_a_((boolean)w.func_201670_d());
    }

    public void func_180655_c(BlockState state, World w, BlockPos pos, Random r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        VibrationChamberTileEntity tc = (VibrationChamberTileEntity)this.getTileEntity((IBlockReader)w, pos);
        if (tc != null && tc.isOn) {
            double f1 = (float)pos.func_177958_n() + 0.5f;
            double f2 = (float)pos.func_177956_o() + 0.5f;
            double f3 = (float)pos.func_177952_p() + 0.5f;
            Direction forward = tc.getForward();
            Direction up = tc.getUp();
            int west_x = forward.func_96559_d() * up.func_82599_e() - forward.func_82599_e() * up.func_96559_d();
            int west_y = forward.func_82599_e() * up.func_82601_c() - forward.func_82601_c() * up.func_82599_e();
            int west_z = forward.func_82601_c() * up.func_96559_d() - forward.func_96559_d() * up.func_82601_c();
            f1 += (double)forward.func_82601_c() * 0.6;
            f2 += (double)forward.func_96559_d() * 0.6;
            f3 += (double)forward.func_82599_e() * 0.6;
            double ox = r.nextDouble();
            double oy = r.nextDouble() * (double)0.2f;
            f1 += (double)up.func_82601_c() * (-0.3 + oy);
            f2 += (double)up.func_96559_d() * (-0.3 + oy);
            f3 += (double)up.func_82599_e() * (-0.3 + oy);
            w.func_195594_a((IParticleData)ParticleTypes.field_197601_L, f1 += (double)west_x * (0.3 * ox - 0.15), f2 += (double)west_y * (0.3 * ox - 0.15), f3 += (double)west_z * (0.3 * ox - 0.15), 0.0, 0.0, 0.0);
            w.func_195594_a((IParticleData)ParticleTypes.field_197631_x, f1, f2, f3, 0.0, 0.0, 0.0);
        }
    }
}

