/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.cablebus.CableBusBakedModel;
import appeng.client.render.cablebus.CableBusBreakingParticle;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ClickPacket;
import appeng.helpers.AEMaterials;
import appeng.integration.abstraction.IAEFacade;
import appeng.parts.CableBusContainer;
import appeng.parts.ICableBusContainer;
import appeng.parts.NullCableBusContainer;
import appeng.tile.AEBaseTileEntity;
import appeng.tile.networking.CableBusTileEntity;
import appeng.util.Platform;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CableBusBlock
extends AEBaseTileBlock<CableBusTileEntity>
implements IAEFacade,
IWaterLoggable {
    private static final ICableBusContainer NULL_CABLE_BUS = new NullCableBusContainer();
    private static final IntegerProperty LIGHT_LEVEL = IntegerProperty.func_177719_a((String)"light_level", (int)0, (int)15);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public CableBusBlock() {
        super(CableBusBlock.defaultProps(AEMaterials.GLASS).func_226896_b_().func_222380_e().func_208770_d().func_235838_a_(state -> (Integer)state.func_177229_b((Property)LIGHT_LEVEL)));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
        this.cb((IBlockReader)worldIn, pos).animateTick(worldIn, pos, rand);
    }

    public void onNeighborChange(BlockState state, IWorldReader w, BlockPos pos, BlockPos neighbor) {
        this.cb((IBlockReader)w, pos).onNeighborChanged((IBlockReader)w, pos, neighbor);
    }

    public int func_180656_a(BlockState state, IBlockReader w, BlockPos pos, Direction side) {
        return this.cb(w, pos).isProvidingWeakPower(side.func_176734_d());
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public void func_196262_a(BlockState state, World w, BlockPos pos, Entity entityIn) {
        this.cb((IBlockReader)w, pos).onEntityCollision(entityIn);
    }

    public int func_176211_b(BlockState state, IBlockReader w, BlockPos pos, Direction side) {
        return this.cb(w, pos).isProvidingStrongPower(side.func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{LIGHT_LEVEL, WATERLOGGED});
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return this.cb((IBlockReader)world, pos).isLadder(entity);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return super.func_196253_a(state, useContext) && this.cb((IBlockReader)useContext.func_195991_k(), useContext.func_195995_a()).isEmpty();
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        Object tile;
        if (player.field_71075_bZ.field_75098_d && (tile = this.getTileEntity((IBlockReader)world, pos)) != null) {
            ((AEBaseTileEntity)tile).disableDrops();
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader w, BlockPos pos, Direction side) {
        if (side == null) {
            return false;
        }
        return this.cb(w, pos).canConnectRedstone(side.func_176734_d());
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        Vector3d v3 = target.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        SelectedPart sp = this.cb(world, pos).selectPart(v3);
        if (sp.part != null) {
            return sp.part.getItemStack(PartItemStack.PICK);
        }
        if (sp.facade != null) {
            return sp.facade.getItemStack();
        }
        return ItemStack.field_190927_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        if (Platform.getRandom().nextBoolean()) {
            return true;
        }
        if (target.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return false;
        }
        BlockPos blockPos = new BlockPos(target.func_216347_e().field_72450_a, target.func_216347_e().field_72448_b, target.func_216347_e().field_72449_c);
        ICableBusContainer cb = this.cb((IBlockReader)world, blockPos);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(this.func_176223_P());
        if (!(model instanceof CableBusBakedModel)) {
            return true;
        }
        CableBusBakedModel cableBusModel = (CableBusBakedModel)model;
        CableBusRenderState renderState = cb.getRenderState();
        TextureAtlasSprite texture = Platform.pickRandom(cableBusModel.getParticleTextures(renderState));
        if (texture != null) {
            double x = target.func_216347_e().field_72450_a;
            double y = target.func_216347_e().field_72448_b;
            double z = target.func_216347_e().field_72449_c;
            effectRenderer.func_78873_a(new CableBusBreakingParticle((ClientWorld)world, x, y, z, texture).func_70541_f(0.8f));
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager effectRenderer) {
        ICableBusContainer cb = this.cb((IBlockReader)world, pos);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(this.func_176223_P());
        if (!(model instanceof CableBusBakedModel)) {
            return true;
        }
        CableBusBakedModel cableBusModel = (CableBusBakedModel)model;
        CableBusRenderState renderState = cb.getRenderState();
        List<TextureAtlasSprite> textures = cableBusModel.getParticleTextures(renderState);
        if (!textures.isEmpty()) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        TextureAtlasSprite texture = Platform.pickRandom(textures);
                        double x = (double)pos.func_177958_n() + ((double)j + 0.5) / 4.0;
                        double y = (double)pos.func_177956_o() + ((double)k + 0.5) / 4.0;
                        double z = (double)pos.func_177952_p() + ((double)l + 0.5) / 4.0;
                        CableBusBreakingParticle effect = new CableBusBreakingParticle((ClientWorld)world, x, y, z, x - (double)pos.func_177958_n() - 0.5, y - (double)pos.func_177956_o() - 0.5, z - (double)pos.func_177952_p() - 0.5, texture);
                        effectRenderer.func_78873_a((Particle)effect);
                    }
                }
            }
        }
        return true;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!world.func_201670_d()) {
            this.cb((IBlockReader)world, pos).onNeighborChanged((IBlockReader)world, pos, fromPos);
        }
    }

    private ICableBusContainer cb(IBlockReader w, BlockPos pos) {
        TileEntity te = w.func_175625_s(pos);
        CableBusContainer out = null;
        if (te instanceof CableBusTileEntity) {
            out = ((CableBusTileEntity)te).getCableBus();
        }
        return out == null ? NULL_CABLE_BUS : out;
    }

    @Nullable
    private IFacadeContainer fc(IBlockReader w, BlockPos pos) {
        TileEntity te = w.func_175625_s(pos);
        IFacadeContainer out = null;
        if (te instanceof CableBusTileEntity) {
            out = ((CableBusTileEntity)te).getCableBus().getFacadeContainer();
        }
        return out;
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        BlockRayTraceResult brtr;
        RayTraceResult rtr;
        if (worldIn.func_201670_d() && (rtr = Minecraft.func_71410_x().field_71476_x) instanceof BlockRayTraceResult && (brtr = (BlockRayTraceResult)rtr).func_216350_a().equals((Object)pos)) {
            Vector3d hitVec = rtr.func_216347_e().func_178788_d(new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
            if (this.cb((IBlockReader)worldIn, pos).clicked(player, Hand.MAIN_HAND, hitVec)) {
                NetworkHandler.instance().sendToServer(new ClickPacket(pos, brtr.func_216354_b(), (float)hitVec.field_72450_a, (float)hitVec.field_72448_b, (float)hitVec.field_72449_c, Hand.MAIN_HAND, true));
            }
        }
    }

    public void onBlockClickPacket(World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, Vector3d hitVec) {
        this.cb((IBlockReader)worldIn, pos).clicked(playerIn, hand, hitVec);
    }

    @Override
    public ActionResultType onActivated(World w, BlockPos pos, PlayerEntity player, Hand hand, @Nullable ItemStack heldItem, BlockRayTraceResult hit) {
        Vector3d hitVec = hit.func_216347_e();
        Vector3d hitInBlock = new Vector3d(hitVec.field_72450_a - (double)pos.func_177958_n(), hitVec.field_72448_b - (double)pos.func_177956_o(), hitVec.field_72449_c - (double)pos.func_177952_p());
        return this.cb((IBlockReader)w, pos).activate(player, hand, hitInBlock) ? ActionResultType.func_233537_a_((boolean)w.func_201670_d()) : ActionResultType.PASS;
    }

    public boolean recolorBlock(IBlockReader world, BlockPos pos, Direction side, DyeColor color, PlayerEntity who) {
        try {
            return this.cb(world, pos).recolourBlock(side, AEColor.values()[color.ordinal()], who);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> itemStacks) {
    }

    @Override
    public BlockState getFacadeState(IBlockReader world, BlockPos pos, Direction side) {
        IFacadePart facade;
        IFacadeContainer container;
        if (side != null && (container = this.fc(world, pos)) != null && (facade = container.getFacade(AEPartLocation.fromFacing(side))) != null) {
            return facade.getBlockState();
        }
        return world.func_180495_p(pos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader w, BlockPos pos, ISelectionContext context) {
        CableBusTileEntity te = (CableBusTileEntity)this.getTileEntity(w, pos);
        if (te == null) {
            return VoxelShapes.func_197880_a();
        }
        return te.getCableBus().getShape();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader w, BlockPos pos, ISelectionContext context) {
        CableBusTileEntity te = (CableBusTileEntity)this.getTileEntity(w, pos);
        if (te == null) {
            return VoxelShapes.func_197880_a();
        }
        return te.getCableBus().getCollisionShape(context.getEntity());
    }

    @Override
    protected BlockState updateBlockStateFromTileEntity(BlockState currentState, CableBusTileEntity te) {
        if (currentState.func_177230_c() != this) {
            return currentState;
        }
        int lightLevel = te.getCableBus().getLightValue();
        return (BlockState)super.updateBlockStateFromTileEntity(currentState, te).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(lightLevel));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        FluidState fluidState = context.func_195991_k().func_204610_c(pos);
        BlockState blockState = (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        return blockState;
    }

    public FluidState func_204507_t(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(blockState);
    }

    public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(blockState, facing, facingState, world, currentPos, facingPos);
    }
}

