/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.ActionItems;
import appeng.api.config.CopyMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.container.implementations.CellWorkbenchContainer;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;

public class CellWorkbenchScreen
extends UpgradeableScreen<CellWorkbenchContainer> {
    private final ToggleButton copyMode;
    private final SettingToggleButton<FuzzyMode> fuzzyMode = this.addToLeftToolbar(new SettingToggleButton<FuzzyMode>(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL, this::toggleFuzzyMode));

    public CellWorkbenchScreen(CellWorkbenchContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.addToLeftToolbar(new ActionButton(ActionItems.WRENCH, act -> this.action("Partition")));
        this.addToLeftToolbar(new ActionButton(ActionItems.CLOSE, act -> this.action("Clear")));
        this.copyMode = this.addToLeftToolbar(new ToggleButton(Icon.COPY_MODE_ON, Icon.COPY_MODE_OFF, GuiText.CopyMode.text(), GuiText.CopyModeDesc.text(), act -> this.action("CopyMode")));
    }

    @Override
    protected List<ITextComponent> getCompatibleUpgrades() {
        ItemStack workbenchItem = ((CellWorkbenchContainer)this.field_147002_h).getWorkbenchItem();
        if (workbenchItem.func_190926_b()) {
            return Collections.emptyList();
        }
        return super.getCompatibleUpgrades(workbenchItem.func_77973_b());
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.copyMode.setState(((CellWorkbenchContainer)this.field_147002_h).getCopyMode() == CopyMode.CLEAR_ON_REMOVE);
        boolean hasFuzzy = false;
        IItemHandler inv = ((CellWorkbenchContainer)this.field_147002_h).getCellUpgradeInventory();
        for (int x = 0; x < inv.getSlots(); ++x) {
            ItemStack is = inv.getStackInSlot(x);
            if (is.func_190926_b() || !(is.func_77973_b() instanceof IUpgradeModule) || ((IUpgradeModule)is.func_77973_b()).getType(is) != Upgrades.FUZZY) continue;
            hasFuzzy = true;
        }
        this.fuzzyMode.setVisibility(hasFuzzy);
    }

    private void action(String type) {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("CellWorkbench.Action", type));
    }

    private void toggleFuzzyMode(SettingToggleButton<FuzzyMode> button, boolean backwards) {
        FuzzyMode fz = button.getNextValue(backwards);
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("CellWorkbench.Fuzzy", fz.name()));
    }
}

