/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.container.implementations.IOBusContainer;
import appeng.parts.automation.ExportBusPart;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class IOBusScreen
extends UpgradeableScreen<IOBusContainer> {
    private final SettingToggleButton<RedstoneMode> redstoneMode = new ServerSettingToggleButton<RedstoneMode>(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
    private final SettingToggleButton<FuzzyMode> fuzzyMode;
    private final SettingToggleButton<YesNo> craftMode;
    private final SettingToggleButton<SchedulingMode> schedulingMode;

    public IOBusScreen(IOBusContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.addToLeftToolbar(this.redstoneMode);
        this.fuzzyMode = new ServerSettingToggleButton<FuzzyMode>(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.addToLeftToolbar(this.fuzzyMode);
        if (container.getUpgradeable() instanceof ExportBusPart) {
            this.craftMode = new ServerSettingToggleButton<YesNo>(Settings.CRAFT_ONLY, YesNo.NO);
            this.addToLeftToolbar(this.craftMode);
            this.schedulingMode = new ServerSettingToggleButton<SchedulingMode>(Settings.SCHEDULING_MODE, SchedulingMode.DEFAULT);
            this.addToLeftToolbar(this.schedulingMode);
        } else {
            this.craftMode = null;
            this.schedulingMode = null;
        }
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.redstoneMode.set(((IOBusContainer)this.field_147002_h).getRedStoneMode());
        this.redstoneMode.setVisibility(((IOBusContainer)this.field_147002_h).hasUpgrade(Upgrades.REDSTONE));
        this.fuzzyMode.set(((IOBusContainer)this.field_147002_h).getFuzzyMode());
        this.fuzzyMode.setVisibility(((IOBusContainer)this.field_147002_h).hasUpgrade(Upgrades.FUZZY));
        if (this.craftMode != null) {
            this.craftMode.set(((IOBusContainer)this.field_147002_h).getCraftingMode());
            this.craftMode.setVisibility(((IOBusContainer)this.field_147002_h).hasUpgrade(Upgrades.CRAFTING));
        }
        if (this.schedulingMode != null) {
            this.schedulingMode.set(((IOBusContainer)this.field_147002_h).getSchedulingMode());
            this.schedulingMode.setVisibility(((IOBusContainer)this.field_147002_h).hasUpgrade(Upgrades.CAPACITY));
        }
    }
}

