/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.interfaceterminal;

import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.client.ActionKey;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.interfaceterminal.InterfaceRecord;
import appeng.client.gui.me.interfaceterminal.InterfaceSlot;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.container.implementations.InterfaceTerminalContainer;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class InterfaceTerminalScreen
extends AEBaseScreen<InterfaceTerminalContainer> {
    private static final int GUI_WIDTH = 195;
    private static final int GUI_PADDING_X = 8;
    private static final int GUI_PADDING_Y = 6;
    private static final int GUI_HEADER_HEIGHT = 17;
    private static final int GUI_FOOTER_HEIGHT = 97;
    private static final int INTERFACE_NAME_MARGIN_X = 2;
    private static final int TEXT_MAX_WIDTH = 155;
    private static final int ROW_HEIGHT = 18;
    private static final int DEFAULT_ROW_COUNT = 6;
    private static final int MIN_ROW_COUNT = 3;
    private static final int SLOT_SIZE = 18;
    private static final Rectangle2d HEADER_BBOX = new Rectangle2d(0, 0, 195, 17);
    private static final Rectangle2d ROW_TEXT_TOP_BBOX = new Rectangle2d(0, 17, 195, 18);
    private static final Rectangle2d ROW_TEXT_MIDDLE_BBOX = new Rectangle2d(0, 53, 195, 18);
    private static final Rectangle2d ROW_TEXT_BOTTOM_BBOX = new Rectangle2d(0, 89, 195, 18);
    private static final Rectangle2d ROW_INVENTORY_TOP_BBOX = new Rectangle2d(0, 35, 195, 18);
    private static final Rectangle2d ROW_INVENTORY_MIDDLE_BBOX = new Rectangle2d(0, 71, 195, 18);
    private static final Rectangle2d ROW_INVENTORY_BOTTOM_BBOX = new Rectangle2d(0, 107, 195, 18);
    private static final Rectangle2d FOOTER_BBOX = new Rectangle2d(0, 125, 195, 97);
    private final HashMap<Long, InterfaceRecord> byId = new HashMap();
    private final HashMultimap<String, InterfaceRecord> byName = HashMultimap.create();
    private final ArrayList<String> names = new ArrayList();
    private final ArrayList<Object> lines = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar");
    private boolean refreshList = false;
    private AETextField searchField;
    private int numLines = 0;

    public InterfaceTerminalScreen(InterfaceTerminalContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.field_146999_f = 195;
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        this.addToLeftToolbar(new SettingToggleButton<TerminalStyle>(Settings.TERMINAL_STYLE, terminalStyle, this::toggleTerminalStyle));
    }

    @Override
    public void func_231160_c_() {
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        int maxLines = terminalStyle == TerminalStyle.SMALL ? 6 : Integer.MAX_VALUE;
        this.numLines = (this.field_230709_l_ - 17 - 97) / 18;
        this.numLines = MathHelper.func_76125_a((int)this.numLines, (int)3, (int)maxLines);
        this.field_147000_g = 114 + this.numLines * 18;
        super.func_231160_c_();
        this.searchField = new AETextField(this.field_230712_o_, this.field_147003_i + 104, this.field_147009_r + 4, 65, 12);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146189_e(true);
        this.searchField.func_212954_a(str -> this.refreshList());
        this.func_230481_d_((IGuiEventListener)this.searchField);
        this.func_212932_b((IGuiEventListener)this.searchField);
        this.func_231049_c__(true);
        this.resetScrollbar();
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        ((InterfaceTerminalContainer)this.field_147002_h).field_75151_b.removeIf(slot -> slot instanceof InterfaceSlot);
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < this.numLines; ++i) {
            if (scrollLevel + i >= this.lines.size()) continue;
            Object lineObj = this.lines.get(scrollLevel + i);
            if (lineObj instanceof InterfaceRecord) {
                InterfaceRecord inv = (InterfaceRecord)lineObj;
                for (int z = 0; z < inv.getInventory().getSlots(); ++z) {
                    ((InterfaceTerminalContainer)this.field_147002_h).field_75151_b.add(new InterfaceSlot(inv, z, z * 18 + 8, (i + 1) * 18));
                }
                continue;
            }
            if (!(lineObj instanceof String)) continue;
            String name = (String)lineObj;
            int rows = this.byName.get((Object)name).size();
            if (rows > 1) {
                name = name + " (" + rows + ')';
            }
            name = this.field_230712_o_.func_238413_a_(name, 155, true);
            this.field_230712_o_.func_238421_b_(matrixStack, name, 10.0f, (float)(23 + i * 18), textColor);
        }
    }

    @Override
    public boolean func_231044_a_(double xCoord, double yCoord, int btn) {
        if (this.searchField.func_231044_a_(xCoord, yCoord, btn)) {
            return true;
        }
        if (btn == 1 && this.searchField.func_231047_b_(xCoord, yCoord)) {
            this.searchField.func_146180_a("");
            return true;
        }
        return super.func_231044_a_(xCoord, yCoord, btn);
    }

    @Override
    protected void func_184098_a(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof InterfaceSlot) {
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (!this.getPlayer().field_71075_bZ.field_75098_d) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                InterfaceSlot machineSlot = (InterfaceSlot)slot;
                InventoryActionPacket p = new InventoryActionPacket(action, machineSlot.getSlotIndex(), machineSlot.getMachineInv().getServerId());
                NetworkHandler.instance().sendToServer(p);
            }
            return;
        }
        super.func_184098_a(slot, slotIdx, mouseButton, clickType);
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture("guis/interfaceterminal.png");
        this.blit(matrixStack, offsetX, offsetY, HEADER_BBOX);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int currentY = offsetY + 17;
        this.blit(matrixStack, offsetX, currentY + this.numLines * 18, FOOTER_BBOX);
        for (int i = 0; i < this.numLines; ++i) {
            boolean firstLine = i == 0;
            boolean lastLine = i == this.numLines - 1;
            boolean isInvLine = false;
            if (scrollLevel + i < this.lines.size()) {
                Object lineObj = this.lines.get(scrollLevel + i);
                isInvLine = lineObj instanceof InterfaceRecord;
            }
            Rectangle2d bbox = this.selectRowBackgroundBox(isInvLine, firstLine, lastLine);
            this.blit(matrixStack, offsetX, currentY, bbox);
            currentY += 18;
        }
        if (this.searchField != null) {
            this.searchField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    private Rectangle2d selectRowBackgroundBox(boolean isInvLine, boolean firstLine, boolean lastLine) {
        if (isInvLine) {
            if (firstLine) {
                return ROW_INVENTORY_TOP_BBOX;
            }
            if (lastLine) {
                return ROW_INVENTORY_BOTTOM_BBOX;
            }
            return ROW_INVENTORY_MIDDLE_BBOX;
        }
        if (firstLine) {
            return ROW_TEXT_TOP_BBOX;
        }
        if (lastLine) {
            return ROW_TEXT_BOTTOM_BBOX;
        }
        return ROW_TEXT_MIDDLE_BBOX;
    }

    public boolean func_231042_a_(char character, int key) {
        if (character == ' ' && this.searchField.func_146179_b().isEmpty()) {
            return true;
        }
        return super.func_231042_a_(character, key);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int p_keyPressed_3_) {
        InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode != 256) {
            if (AppEng.proxy.isActionKey(ActionKey.TOGGLE_FOCUS, input)) {
                this.searchField.func_146195_b(!this.searchField.func_230999_j_());
                return true;
            }
            if (this.searchField.func_230999_j_()) {
                if (keyCode == 257) {
                    this.searchField.func_146195_b(false);
                    return true;
                }
                this.searchField.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
    }

    public void postUpdate(boolean fullUpdate, CompoundNBT in) {
        if (fullUpdate) {
            this.byId.clear();
            this.refreshList = true;
        }
        for (String key : in.func_150296_c()) {
            if (!key.startsWith("=")) continue;
            try {
                long id = Long.parseLong(key.substring(1), 36);
                CompoundNBT invData = in.func_74775_l(key);
                IFormattableTextComponent un = ITextComponent.Serializer.func_240643_a_((String)invData.func_74779_i("un"));
                InterfaceRecord current = this.getById(id, invData.func_74763_f("sortBy"), (ITextComponent)un);
                for (int x = 0; x < current.getInventory().getSlots(); ++x) {
                    String which = Integer.toString(x);
                    if (!invData.func_74764_b(which)) continue;
                    current.getInventory().setStackInSlot(x, ItemStack.func_199557_a((CompoundNBT)invData.func_74775_l(which)));
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.refreshList();
        }
    }

    private void refreshList() {
        this.byName.clear();
        String searchFilterLowerCase = this.searchField.func_146179_b().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFilterLowerCase);
        boolean rebuild = cachedSearch.isEmpty();
        for (InterfaceRecord entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFilterLowerCase.isEmpty();
            if (!found) {
                ItemStack itemStack;
                Iterator<ItemStack> iterator = entry.getInventory().iterator();
                while (iterator.hasNext() && !(found = this.itemStackMatchesSearchTerm(itemStack = iterator.next(), searchFilterLowerCase))) {
                }
            }
            if (found || entry.getSearchName().contains(searchFilterLowerCase)) {
                this.byName.put((Object)entry.getDisplayName(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.getMaxRows());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.resetScrollbar();
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(this.numLines * 18 - 2);
        this.scrollbar.setRange(0, this.lines.size() - this.numLines, 2);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        CompoundNBT encodedValue = itemStack.func_77978_p();
        if (encodedValue == null) {
            return false;
        }
        ListNBT outTag = encodedValue.func_150295_c("out", 10);
        for (int i = 0; i < outTag.size(); ++i) {
            String displayName;
            ItemStack parsedItemStack = ItemStack.func_199557_a((CompoundNBT)outTag.func_150305_b(i));
            if (parsedItemStack.func_190926_b() || !(displayName = Platform.getItemDisplayName(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(parsedItemStack)).getString().toLowerCase()).contains(searchTerm)) continue;
            return true;
        }
        return false;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
        }
        return cache;
    }

    private void reinitialize() {
        this.field_230705_e_.removeAll(this.field_230710_m_);
        this.field_230710_m_.clear();
        this.func_231160_c_();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set(next);
        this.reinitialize();
    }

    private int getMaxRows() {
        return this.names.size() + this.byId.size();
    }

    private InterfaceRecord getById(long id, long sortBy, ITextComponent name) {
        InterfaceRecord o = this.byId.get(id);
        if (o == null) {
            o = new InterfaceRecord(id, 9, sortBy, name);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }

    private void blit(MatrixStack matrixStack, int offsetX, int offsetY, Rectangle2d srcRect) {
        this.func_238474_b_(matrixStack, offsetX, offsetY, srcRect.func_199318_a(), srcRect.func_199319_b(), srcRect.func_199316_c(), srcRect.func_199317_d());
    }
}

