/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.block.storage.DriveSlotState;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.EnumMap;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.vector.Vector3f;

class CellLedRenderer {
    private static final EnumMap<DriveSlotState, Vector3f> STATE_COLORS;
    private static final Vector3f BLINK_COLOR;
    private static final float L = 0.3125f;
    private static final float R = 0.25f;
    private static final float T = 0.0625f;
    private static final float B = -6.25E-5f;
    private static final float FR = -6.25E-5f;
    private static final float BA = 0.0311875f;
    private static final float[] LED_QUADS;
    public static final RenderType RENDER_LAYER;

    public static void renderLed(IChestOrDrive drive, int slot, IVertexBuilder buffer, MatrixStack ms, float partialTicks) {
        Vector3f color = CellLedRenderer.getColorForSlot(drive, slot, partialTicks);
        if (color == null) {
            return;
        }
        for (int i = 0; i < LED_QUADS.length; i += 3) {
            float x = LED_QUADS[i];
            float y = LED_QUADS[i + 1];
            float z = LED_QUADS[i + 2];
            buffer.func_227888_a_(ms.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_(color.func_195899_a(), color.func_195900_b(), color.func_195902_c(), 1.0f).func_181675_d();
        }
    }

    private static Vector3f getColorForSlot(IChestOrDrive drive, int slot, float partialTicks) {
        DriveSlotState state = DriveSlotState.fromCellStatus(drive.getCellStatus(slot));
        if (state == DriveSlotState.EMPTY) {
            return null;
        }
        if (!drive.isPowered()) {
            return STATE_COLORS.get((Object)DriveSlotState.OFFLINE);
        }
        Vector3f col = STATE_COLORS.get((Object)state);
        if (drive.isCellBlinking(slot)) {
            long t = System.currentTimeMillis() % 200L;
            float f = (float)(t - 100L) / 200.0f + 0.5f;
            f = CellLedRenderer.easeInOutCubic(f);
            col = col.func_229195_e_();
            col.func_229190_a_(BLINK_COLOR, f);
        }
        return col;
    }

    private static float easeInOutCubic(float x) {
        return x < 0.5f ? 4.0f * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0f;
    }

    private CellLedRenderer() {
    }

    static {
        BLINK_COLOR = new Vector3f(1.0f, 0.5f, 0.5f);
        STATE_COLORS = new EnumMap(DriveSlotState.class);
        STATE_COLORS.put(DriveSlotState.OFFLINE, new Vector3f(0.0f, 0.0f, 0.0f));
        STATE_COLORS.put(DriveSlotState.ONLINE, new Vector3f(0.0f, 1.0f, 0.0f));
        STATE_COLORS.put(DriveSlotState.NOT_EMPTY, new Vector3f(0.0f, 0.667f, 1.0f));
        STATE_COLORS.put(DriveSlotState.TYPES_FULL, new Vector3f(1.0f, 0.667f, 0.0f));
        STATE_COLORS.put(DriveSlotState.FULL, new Vector3f(1.0f, 0.0f, 0.0f));
        LED_QUADS = new float[]{0.25f, 0.0625f, -6.25E-5f, 0.3125f, 0.0625f, -6.25E-5f, 0.3125f, -6.25E-5f, -6.25E-5f, 0.25f, -6.25E-5f, -6.25E-5f, 0.3125f, 0.0625f, -6.25E-5f, 0.3125f, 0.0625f, 0.0311875f, 0.3125f, -6.25E-5f, 0.0311875f, 0.3125f, -6.25E-5f, -6.25E-5f, 0.25f, 0.0625f, 0.0311875f, 0.25f, 0.0625f, -6.25E-5f, 0.25f, -6.25E-5f, -6.25E-5f, 0.25f, -6.25E-5f, 0.0311875f, 0.25f, 0.0625f, 0.0311875f, 0.3125f, 0.0625f, 0.0311875f, 0.3125f, 0.0625f, -6.25E-5f, 0.25f, 0.0625f, -6.25E-5f, 0.25f, -6.25E-5f, -6.25E-5f, 0.3125f, -6.25E-5f, -6.25E-5f, 0.3125f, -6.25E-5f, 0.0311875f, 0.25f, -6.25E-5f, 0.0311875f};
        RENDER_LAYER = RenderType.func_228633_a_((String)"ae_drive_leds", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)32565, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228728_a_(false));
    }
}

