/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.tesr;

import appeng.block.storage.SkyChestBlock;
import appeng.tile.storage.SkyChestTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;

@OnlyIn(value=Dist.CLIENT)
public class SkyChestTESR
extends TileEntityRenderer<SkyChestTileEntity> {
    public static final RenderMaterial TEXTURE_STONE = new RenderMaterial(Atlases.field_228747_f_, new ResourceLocation("appliedenergistics2", "models/skychest"));
    public static final RenderMaterial TEXTURE_BLOCK = new RenderMaterial(Atlases.field_228747_f_, new ResourceLocation("appliedenergistics2", "models/skyblockchest"));
    private final ModelRenderer singleLid;
    private final ModelRenderer singleBottom = new ModelRenderer(64, 64, 0, 19);
    private final ModelRenderer singleLatch;

    public SkyChestTESR(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        this.singleBottom.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.singleLid = new ModelRenderer(64, 64, 0, 0);
        this.singleLid.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.singleLid.field_78797_d = 10.0f;
        this.singleLid.field_78798_e = 1.0f;
        this.singleLatch = new ModelRenderer(64, 64, 0, 0);
        this.singleLatch.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.singleLatch.field_78797_d = 9.0f;
    }

    public void render(SkyChestTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.func_227860_a_();
        float f = tileEntityIn.getForward().func_185119_l();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
        matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
        float f1 = tileEntityIn.func_195480_a(partialTicks);
        f1 = 1.0f - f1;
        f1 = 1.0f - f1 * f1 * f1;
        RenderMaterial material = this.getRenderMaterial(tileEntityIn);
        IVertexBuilder ivertexbuilder = material.func_229311_a_(bufferIn, RenderType::func_228638_b_);
        this.renderModels(matrixStackIn, ivertexbuilder, this.singleLid, this.singleLatch, this.singleBottom, f1, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
    }

    private void renderModels(MatrixStack matrixStackIn, IVertexBuilder bufferIn, ModelRenderer chestLid, ModelRenderer chestLatch, ModelRenderer chestBottom, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        chestLatch.field_78795_f = chestLid.field_78795_f = -(lidAngle * 1.5707964f);
        chestLid.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestLatch.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestBottom.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    protected RenderMaterial getRenderMaterial(SkyChestTileEntity tileEntity) {
        Block blockType;
        SkyChestBlock.SkyChestType type = SkyChestBlock.SkyChestType.BLOCK;
        if (tileEntity.func_145831_w() != null && (blockType = tileEntity.func_195044_w().func_177230_c()) instanceof SkyChestBlock) {
            type = ((SkyChestBlock)blockType).type;
        }
        switch (type) {
            case STONE: {
                return TEXTURE_STONE;
            }
        }
        return TEXTURE_BLOCK;
    }

    public static void registerTextures(TextureStitchEvent.Pre evt) {
        if (evt.getMap().func_229223_g_().equals((Object)Atlases.field_228747_f_)) {
            evt.addSprite(TEXTURE_STONE.func_229313_b_());
            evt.addSprite(TEXTURE_BLOCK.func_229313_b_());
        }
    }
}

