/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.container.AEBaseContainer;
import appeng.container.SlotSemantic;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.RestrictedInputSlot;
import appeng.tile.misc.VibrationChamberTileEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;

public class VibrationChamberContainer
extends AEBaseContainer
implements IProgressProvider {
    public static final ContainerType<VibrationChamberContainer> TYPE = ContainerTypeBuilder.create(VibrationChamberContainer::new, VibrationChamberTileEntity.class).build("vibrationchamber");
    private final VibrationChamberTileEntity vibrationChamber;
    @GuiSync(value=0)
    public int burnSpeed = 0;
    @GuiSync(value=1)
    public int remainingBurnTime = 0;

    public VibrationChamberContainer(int id, PlayerInventory ip, VibrationChamberTileEntity vibrationChamber) {
        super(TYPE, id, ip, vibrationChamber);
        this.vibrationChamber = vibrationChamber;
        this.addSlot(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.FUEL, vibrationChamber.getInternalInventory(), 0), SlotSemantic.MACHINE_INPUT);
        this.createPlayerInventorySlots(ip);
    }

    @Override
    public void func_75142_b() {
        if (this.isServer()) {
            this.remainingBurnTime = this.vibrationChamber.getMaxBurnTime() <= 0.0 ? 0 : (int)(100.0 * this.vibrationChamber.getBurnTime() / this.vibrationChamber.getMaxBurnTime());
            this.burnSpeed = this.remainingBurnTime <= 0 ? 0 : this.vibrationChamber.getBurnSpeed();
        }
        super.func_75142_b();
    }

    @Override
    public int getCurrentProgress() {
        return this.burnSpeed;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    @Override
    public int getMaxProgress() {
        return 200;
    }
}

