/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.common;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.AEBaseContainer;
import appeng.container.SlotSemantic;
import appeng.container.guisync.GuiSync;
import appeng.container.me.common.IClientRepo;
import appeng.container.me.common.IMEInteractionHandler;
import appeng.container.me.common.IncrementalUpdateHelper;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.MEInteractionPacket;
import appeng.core.sync.packets.MEInventoryUpdatePacket;
import appeng.helpers.InventoryAction;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public abstract class MEMonitorableContainer<T extends IAEStack<T>>
extends AEBaseContainer
implements IConfigManagerHost,
IConfigurableObject,
IMEMonitorHandlerReceiver<T>,
IMEInteractionHandler {
    private final List<RestrictedInputSlot> viewCellSlots;
    private final IConfigManager clientCM;
    private final ITerminalHost host;
    @GuiSync(value=99)
    public boolean canEditViewCells;
    @GuiSync(value=98)
    public boolean hasPower = false;
    @GuiSync(value=100)
    public int activeCraftingJobs = -1;
    private IConfigManagerHost gui;
    private IConfigManager serverCM;
    private IGridNode networkNode;
    protected final IEnergySource powerSource;
    protected final IMEMonitor<T> monitor;
    private final IncrementalUpdateHelper<T> updateHelper = new IncrementalUpdateHelper();
    private final IStorageChannel<T> storageChannel;
    @Nullable
    private IClientRepo<T> clientRepo;

    public MEMonitorableContainer(ContainerType<?> containerType, int id, PlayerInventory ip, ITerminalHost host, boolean bindInventory, IStorageChannel<T> storageChannel) {
        super(containerType, id, ip, host);
        this.storageChannel = storageChannel;
        this.host = host;
        this.clientCM = new ConfigManager(this);
        this.clientCM.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        IEnergySource powerSource = null;
        if (this.isServer()) {
            this.serverCM = host.getConfigManager();
            this.monitor = host.getInventory(storageChannel);
            if (this.monitor != null) {
                IGridNode node;
                this.monitor.addListener(this, null);
                if (host instanceof IPortableCell || host instanceof IMEChest) {
                    powerSource = (IEnergySource)((Object)host);
                } else if ((host instanceof IGridHost || host instanceof IActionHost) && (node = host instanceof IGridHost ? ((IGridHost)((Object)host)).getGridNode(AEPartLocation.INTERNAL) : (host instanceof IActionHost ? ((IActionHost)((Object)host)).getActionableNode() : null)) != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    if (g != null) {
                        powerSource = new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class));
                    }
                }
            } else {
                this.setValidContainer(false);
            }
        } else {
            this.monitor = null;
        }
        this.powerSource = powerSource;
        if (!this.hideViewCells() && host instanceof IViewCellStorage) {
            IItemHandler viewCellStorage = ((IViewCellStorage)((Object)host)).getViewCellStorage();
            this.viewCellSlots = new ArrayList<RestrictedInputSlot>(viewCellStorage.getSlots());
            for (int i = 0; i < viewCellStorage.getSlots(); ++i) {
                RestrictedInputSlot slot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.VIEW_CELL, viewCellStorage, i);
                this.addSlot(slot, SlotSemantic.VIEW_CELL);
                this.viewCellSlots.add(slot);
            }
        } else {
            this.viewCellSlots = Collections.emptyList();
        }
        this.updateViewCellPermission();
        if (bindInventory) {
            this.createPlayerInventorySlots(ip);
        }
    }

    protected boolean hideViewCells() {
        return false;
    }

    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    @Override
    public void func_75142_b() {
        if (this.isServer()) {
            if (this.monitor != this.host.getInventory(this.storageChannel)) {
                this.setValidContainer(false);
                return;
            }
            this.updateActiveCraftingJobs();
            for (Settings set : this.serverCM.getSettings()) {
                Enum<?> sideRemote;
                Enum<?> sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                this.clientCM.putSetting(set, sideLocal);
                this.sendPacketToClient(new ConfigValuePacket(set.name(), sideLocal.name()));
            }
            if (this.updateHelper.hasChanges()) {
                try {
                    MEInventoryUpdatePacket.Builder builder = MEInventoryUpdatePacket.builder(this.field_75152_c, this.updateHelper.isFullUpdate());
                    IItemList<T> storageList = this.monitor.getStorageList();
                    if (this.updateHelper.isFullUpdate()) {
                        builder.addFull(this.updateHelper, storageList);
                    } else {
                        builder.addChanges(this.updateHelper, storageList);
                    }
                    builder.buildAndSend(this::sendPacketToClient);
                }
                catch (Exception e) {
                    AELog.warn(e, "Failed to send incremental inventory update to client");
                }
                this.updateHelper.commitChanges();
            }
            this.updatePowerStatus();
            this.updateViewCellPermission();
            super.func_75142_b();
        }
    }

    private void updateViewCellPermission() {
        boolean oldAccessible = this.canEditViewCells;
        this.canEditViewCells = this.hasAccess(SecurityPermissions.BUILD, false);
        if (this.canEditViewCells != oldAccessible) {
            for (RestrictedInputSlot slot : this.viewCellSlots) {
                slot.setAllowEdit(this.canEditViewCells);
            }
        }
    }

    protected void updatePowerStatus() {
        try {
            if (this.networkNode != null) {
                this.setPowered(this.networkNode.isActive());
            } else if (this.powerSource instanceof IEnergyGrid) {
                this.setPowered(((IEnergyGrid)this.powerSource).isNetworkPowered());
            } else {
                this.setPowered(this.powerSource.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void onServerDataSync() {
        super.onServerDataSync();
        for (RestrictedInputSlot slot : this.viewCellSlots) {
            slot.setAllowEdit(this.canEditViewCells);
        }
    }

    private void updateActiveCraftingJobs() {
        IGridNode hostNode = this.networkNode;
        if (hostNode == null && this.host instanceof IActionHost) {
            hostNode = ((IActionHost)((Object)this.host)).getActionableNode();
        }
        IGrid grid = null;
        if (hostNode != null) {
            grid = hostNode.getGrid();
        }
        if (grid == null) {
            this.activeCraftingJobs = -1;
            return;
        }
        int activeJobs = 0;
        ICraftingGrid craftingGrid = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        for (ICraftingCPU cpus : craftingGrid.getCpus()) {
            if (!cpus.isBusy()) continue;
            ++activeJobs;
        }
        this.activeCraftingJobs = activeJobs;
    }

    public void func_82847_b(IContainerListener c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty() && this.monitor != null) {
            this.monitor.removeListener(this);
        }
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener(this);
        }
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return true;
    }

    @Override
    public void postChange(IBaseMonitor<T> monitor, Iterable<T> change, IActionSource source) {
        for (IAEStack is : change) {
            this.updateHelper.addChange(is);
        }
    }

    @Override
    public void onListUpdate() {
        if (this.isServer()) {
            this.updateHelper.clear();
        }
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        if (this.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public List<ItemStack> getViewCells() {
        return this.viewCellSlots.stream().map(AppEngSlot::func_75211_c).collect(Collectors.toList());
    }

    protected final boolean canInteractWithGrid() {
        return this.monitor != null && this.powerSource != null && this.isPowered();
    }

    @Override
    public final void handleInteraction(long serial, InventoryAction action) {
        if (this.isClient()) {
            NetworkHandler.instance().sendToServer(new MEInteractionPacket(this.field_75152_c, serial, action));
            return;
        }
        if (!this.canInteractWithGrid()) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)this.getPlayerInventory().field_70458_d;
        if (serial == -1L) {
            this.handleNetworkInteraction(player, null, action);
            return;
        }
        T stack = this.getStackBySerial(serial);
        if (stack == null) {
            return;
        }
        this.handleNetworkInteraction(player, stack, action);
    }

    protected abstract void handleNetworkInteraction(ServerPlayerEntity var1, @Nullable T var2, InventoryAction var3);

    @Nullable
    protected final T getStackBySerial(long serial) {
        return this.updateHelper.getBySerial(serial);
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    private void setPowered(boolean isPowered) {
        this.hasPower = isPowered;
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    public IStorageChannel<T> getStorageChannel() {
        return this.storageChannel;
    }

    @Nullable
    public IClientRepo<T> getClientRepo() {
        return this.clientRepo;
    }

    public void setClientRepo(@Nullable IClientRepo<T> clientRepo) {
        this.clientRepo = clientRepo;
    }
}

