/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.fluids;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.me.common.MEMonitorableContainer;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.FluidSoundHelper;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidTerminalContainer
extends MEMonitorableContainer<IAEFluidStack> {
    public static final ContainerType<FluidTerminalContainer> TYPE = ContainerTypeBuilder.create(FluidTerminalContainer::new, ITerminalHost.class).requirePermission(SecurityPermissions.BUILD).build("fluid_terminal");

    public FluidTerminalContainer(int id, PlayerInventory ip, ITerminalHost monitorable) {
        this(TYPE, id, ip, monitorable, true);
    }

    public FluidTerminalContainer(ContainerType<?> containerType, int id, PlayerInventory ip, ITerminalHost host, boolean bindInventory) {
        super(containerType, id, ip, host, bindInventory, Api.instance().storage().getStorageChannel(IFluidStorageChannel.class));
    }

    @Override
    protected boolean hideViewCells() {
        return true;
    }

    @Override
    protected void handleNetworkInteraction(ServerPlayerEntity player, @Nullable IAEFluidStack stack, InventoryAction action) {
        if (action != InventoryAction.FILL_ITEM && action != InventoryAction.EMPTY_ITEM) {
            return;
        }
        ItemStack held = player.field_71071_by.func_70445_o();
        if (held.func_190916_E() != 1) {
            return;
        }
        LazyOptional fhOpt = FluidUtil.getFluidHandler((ItemStack)held);
        if (!fhOpt.isPresent()) {
            return;
        }
        IFluidHandlerItem fh = (IFluidHandlerItem)fhOpt.orElse(null);
        if (action == InventoryAction.FILL_ITEM && stack != null) {
            stack.setStackSize(Integer.MAX_VALUE);
            int amountAllowed = fh.fill(stack.getFluidStack(), IFluidHandler.FluidAction.SIMULATE);
            stack.setStackSize(amountAllowed);
            IAEFluidStack canPull = Platform.poweredExtraction(this.powerSource, this.monitor, stack, this.getActionSource(), Actionable.SIMULATE);
            if (canPull == null || canPull.getStackSize() < 1L) {
                return;
            }
            int canFill = fh.fill(canPull.getFluidStack(), IFluidHandler.FluidAction.SIMULATE);
            if (canFill == 0) {
                return;
            }
            stack.setStackSize(canFill);
            IAEFluidStack pulled = Platform.poweredExtraction(this.powerSource, this.monitor, stack, this.getActionSource());
            if (pulled == null || pulled.getStackSize() < 1L) {
                AELog.error("Unable to pull fluid out of the ME system even though the simulation said yes ", new Object[0]);
                return;
            }
            int used = fh.fill(pulled.getFluidStack(), IFluidHandler.FluidAction.EXECUTE);
            if (used != canFill) {
                AELog.error("Fluid item [%s] reported a different possible amount than it actually accepted.", held.func_200301_q());
            }
            player.field_71071_by.func_70437_b(fh.getContainer());
            this.updateHeld(player);
            FluidSoundHelper.playFillSound((PlayerEntity)player, pulled.getFluidStack());
        } else if (action == InventoryAction.EMPTY_ITEM) {
            FluidStack extract = fh.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            if (extract.isEmpty() || extract.getAmount() < 1) {
                return;
            }
            IAEFluidStack notStorable = Platform.poweredInsert(this.powerSource, this.monitor, AEFluidStack.fromFluidStack(extract), this.getActionSource(), Actionable.SIMULATE);
            if (notStorable != null && notStorable.getStackSize() > 0L) {
                int toStore = (int)((long)extract.getAmount() - notStorable.getStackSize());
                FluidStack storable = fh.drain(toStore, IFluidHandler.FluidAction.SIMULATE);
                if (storable.isEmpty() || storable.getAmount() == 0) {
                    return;
                }
                extract.setAmount(storable.getAmount());
            }
            FluidStack drained = fh.drain(extract, IFluidHandler.FluidAction.EXECUTE);
            extract.setAmount(drained.getAmount());
            IAEFluidStack notInserted = Platform.poweredInsert(this.powerSource, this.monitor, AEFluidStack.fromFluidStack(extract), this.getActionSource());
            if (notInserted != null && notInserted.getStackSize() > 0L) {
                AELog.error("Fluid item [%s] reported a different possible amount to drain than it actually provided.", held.func_200301_q());
            }
            player.field_71071_by.func_70437_b(fh.getContainer());
            this.updateHeld(player);
            FluidSoundHelper.playEmptySound((PlayerEntity)player, extract);
        }
    }
}

