/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.items;

import appeng.api.config.Actionable;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.ContainerLocator;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.me.common.GridInventoryEntry;
import appeng.container.me.common.IClientRepo;
import appeng.container.me.common.MEMonitorableContainer;
import appeng.container.me.crafting.CraftAmountContainer;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.helpers.InventoryAction;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.item.AEItemStack;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemTerminalContainer
extends MEMonitorableContainer<IAEItemStack> {
    public static final ContainerType<ItemTerminalContainer> TYPE = ContainerTypeBuilder.create(ItemTerminalContainer::new, ITerminalHost.class).build("item_terminal");

    public ItemTerminalContainer(int id, PlayerInventory ip, ITerminalHost monitorable) {
        this(TYPE, id, ip, monitorable, true);
    }

    public ItemTerminalContainer(ContainerType<?> containerType, int id, PlayerInventory ip, ITerminalHost host, boolean bindInventory) {
        super(containerType, id, ip, host, bindInventory, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
    }

    @Override
    protected void handleNetworkInteraction(ServerPlayerEntity player, @Nullable IAEItemStack stack, InventoryAction action) {
        if (stack == null) {
            if (action == InventoryAction.SPLIT_OR_PLACE_SINGLE || action == InventoryAction.ROLL_DOWN) {
                this.putHeldItemIntoNetwork(player, true);
            } else if (action == InventoryAction.PICKUP_OR_SET_DOWN) {
                this.putHeldItemIntoNetwork(player, false);
            }
            return;
        }
        switch (action) {
            case AUTO_CRAFT: {
                ContainerLocator locator = this.getLocator();
                if (locator == null) break;
                CraftAmountContainer.open(player, locator, stack, 1);
                break;
            }
            case SHIFT_CLICK: {
                this.moveOneStackToPlayer(stack, player);
                break;
            }
            case ROLL_DOWN: {
                boolean releaseQty = true;
                ItemStack isg = player.field_71071_by.func_70445_o();
                if (isg.func_190926_b()) break;
                IAEItemStack ais = (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(isg);
                ais.setStackSize(1L);
                IAEItemStack extracted = ais.copy();
                ais = Platform.poweredInsert(this.powerSource, this.monitor, ais, this.getActionSource());
                if (ais != null) break;
                AdaptorItemHandler ia = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(player.field_71071_by));
                ItemStack fail = ((InventoryAdaptor)ia).removeItems(1, extracted.getDefinition(), null);
                if (fail.func_190926_b()) {
                    this.monitor.extractItems(extracted, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case ROLL_UP: 
            case PICKUP_SINGLE: {
                int liftQty = 1;
                ItemStack item = player.field_71071_by.func_70445_o();
                if (!item.func_190926_b()) {
                    if (item.func_190916_E() >= item.func_77976_d()) {
                        liftQty = 0;
                    }
                    if (!Platform.itemComparisons().isSameItem(stack.getDefinition(), item)) {
                        liftQty = 0;
                    }
                }
                if (liftQty <= 0) break;
                IAEItemStack ais = stack.copy();
                ais.setStackSize(1L);
                ais = Platform.poweredExtraction(this.powerSource, this.monitor, ais, this.getActionSource());
                if (ais == null) break;
                AdaptorItemHandler ia = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(player.field_71071_by));
                ItemStack fail = ((InventoryAdaptor)ia).addItems(ais.createItemStack());
                if (!fail.func_190926_b()) {
                    this.monitor.injectItems(ais, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case PICKUP_OR_SET_DOWN: {
                if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                    this.putHeldItemIntoNetwork(player, false);
                    break;
                }
                IAEItemStack ais = stack.copy();
                ais.setStackSize(ais.getDefinition().func_77976_d());
                ais = Platform.poweredExtraction(this.powerSource, this.monitor, ais, this.getActionSource());
                if (ais != null) {
                    player.field_71071_by.func_70437_b(ais.createItemStack());
                } else {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
                this.updateHeld(player);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                    this.putHeldItemIntoNetwork(player, true);
                    break;
                }
                IAEItemStack ais = stack.copy();
                long maxSize = ais.getDefinition().func_77976_d();
                ais.setStackSize(maxSize);
                ais = this.monitor.extractItems(ais, Actionable.SIMULATE, this.getActionSource());
                if (ais != null) {
                    long stackSize = Math.min(maxSize, ais.getStackSize());
                    ais.setStackSize(stackSize + 1L >> 1);
                    ais = Platform.poweredExtraction(this.powerSource, this.monitor, ais, this.getActionSource());
                }
                if (ais != null) {
                    player.field_71071_by.func_70437_b(ais.createItemStack());
                } else {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
                this.updateHeld(player);
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.field_71075_bZ.field_75098_d) break;
                ItemStack is = stack.createItemStack();
                is.func_190920_e(is.func_77976_d());
                player.field_71071_by.func_70437_b(is);
                this.updateHeld(player);
                break;
            }
            case MOVE_REGION: {
                int playerInv = player.field_71071_by.field_70462_a.size();
                for (int slotNum = 0; slotNum < playerInv && this.moveOneStackToPlayer(stack, player); ++slotNum) {
                }
                break;
            }
            default: {
                AELog.warn("Received unhandled inventory action %s from client in %s", new Object[]{action, this.getClass()});
            }
        }
    }

    protected void putHeldItemIntoNetwork(ServerPlayerEntity player, boolean singleItem) {
        ItemStack heldStack = player.field_71071_by.func_70445_o();
        AEItemStack stackToInsert = AEItemStack.fromItemStack(heldStack);
        if (stackToInsert == null) {
            return;
        }
        if (singleItem) {
            stackToInsert.setStackSize(1L);
        }
        IAEItemStack remainder = Platform.poweredInsert(this.powerSource, this.monitor, stackToInsert, this.getActionSource());
        long inserted = stackToInsert.getStackSize() - (remainder == null ? 0L : remainder.getStackSize());
        if (inserted >= (long)heldStack.func_190916_E()) {
            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        } else {
            heldStack = heldStack.func_77946_l();
            heldStack.func_190920_e(heldStack.func_190916_E() - (int)inserted);
            player.field_71071_by.func_70437_b(heldStack);
        }
        this.updateHeld(player);
    }

    private boolean moveOneStackToPlayer(IAEItemStack stack, ServerPlayerEntity player) {
        IAEItemStack ais = stack.copy();
        ItemStack myItem = ais.createItemStack();
        ais.setStackSize(myItem.func_77976_d());
        InventoryAdaptor adp = InventoryAdaptor.getAdaptor((PlayerEntity)player);
        myItem.func_190920_e((int)ais.getStackSize());
        myItem = adp.simulateAdd(myItem);
        if (!myItem.func_190926_b()) {
            ais.setStackSize(ais.getStackSize() - (long)myItem.func_190916_E());
        }
        if (ais.getStackSize() <= 0L) {
            return false;
        }
        return (ais = Platform.poweredExtraction(this.powerSource, this.monitor, ais, this.getActionSource())) != null && adp.addItems(ais.createItemStack()).func_190926_b();
    }

    @Override
    protected ItemStack transferStackToContainer(ItemStack input) {
        if (!this.canInteractWithGrid()) {
            return super.transferStackToContainer(input);
        }
        IAEItemStack ais = (IAEItemStack)Platform.poweredInsert(this.powerSource, this.monitor, Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(input), this.getActionSource());
        return ais == null ? ItemStack.field_190927_a : ais.createItemStack();
    }

    public boolean hasItemType(ItemStack itemStack, int amount) {
        IClientRepo clientRepo = this.getClientRepo();
        if (clientRepo != null) {
            for (GridInventoryEntry stack : clientRepo.getAllEntries()) {
                if (!((IAEItemStack)stack.getStack()).equals(itemStack)) continue;
                if (stack.getStoredAmount() >= (long)amount) {
                    return true;
                }
                amount = (int)((long)amount - stack.getStoredAmount());
            }
        }
        return false;
    }
}

