/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.networktool;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.container.me.networktool.MachineGroup;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class NetworkStatus {
    private double averagePowerInjection;
    private double averagePowerUsage;
    private double storedPower;
    private double maxStoredPower;
    private List<MachineGroup> groupedMachines = Collections.emptyList();

    public static NetworkStatus fromGrid(IGrid grid) {
        IEnergyGrid eg = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        NetworkStatus status = new NetworkStatus();
        status.averagePowerInjection = eg.getAvgPowerInjection();
        status.averagePowerUsage = eg.getAvgPowerUsage();
        status.storedPower = eg.getStoredPower();
        status.maxStoredPower = eg.getMaxStoredPower();
        HashMap<AEItemStack, MachineGroup> groupedMachines = new HashMap<AEItemStack, MachineGroup>();
        for (Class clazz : grid.getMachinesClasses()) {
            for (IGridNode machine : grid.getMachines(clazz)) {
                IGridBlock blk = machine.getGridBlock();
                ItemStack is = blk.getMachineRepresentation();
                AEItemStack ais = AEItemStack.fromItemStack(is);
                if (ais == null) continue;
                ais.setStackSize(1L);
                MachineGroup group = (MachineGroup)groupedMachines.get(ais);
                if (group == null) {
                    group = new MachineGroup(is);
                    groupedMachines.put(ais, group);
                }
                group.setCount(group.getCount() + 1);
                group.setIdlePowerUsage(group.getIdlePowerUsage() + blk.getIdlePowerUsage());
            }
        }
        status.groupedMachines = ImmutableList.copyOf(groupedMachines.values());
        return status;
    }

    public double getAveragePowerInjection() {
        return this.averagePowerInjection;
    }

    public double getAveragePowerUsage() {
        return this.averagePowerUsage;
    }

    public double getStoredPower() {
        return this.storedPower;
    }

    public double getMaxStoredPower() {
        return this.maxStoredPower;
    }

    public List<MachineGroup> getGroupedMachines() {
        return this.groupedMachines;
    }

    public static NetworkStatus read(PacketBuffer data) {
        NetworkStatus status = new NetworkStatus();
        status.averagePowerInjection = data.readDouble();
        status.averagePowerUsage = data.readDouble();
        status.storedPower = data.readDouble();
        status.maxStoredPower = data.readDouble();
        int count = data.func_150792_a();
        ImmutableList.Builder machines = ImmutableList.builder();
        for (int i = 0; i < count; ++i) {
            machines.add((Object)MachineGroup.read(data));
        }
        status.groupedMachines = machines.build();
        return status;
    }

    public void write(PacketBuffer data) {
        data.writeDouble(this.averagePowerInjection);
        data.writeDouble(this.averagePowerUsage);
        data.writeDouble(this.storedPower);
        data.writeDouble(this.maxStoredPower);
        data.func_150787_b(this.groupedMachines.size());
        for (MachineGroup machine : this.groupedMachines) {
            machine.write(data);
        }
    }
}

