/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import appeng.api.crafting.ICraftingHelper;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItems;
import appeng.api.definitions.IMaterials;
import appeng.api.features.INetworkEncodable;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.client.gui.Icon;
import appeng.container.slot.AppEngSlot;
import appeng.core.Api;
import appeng.items.misc.EncodedPatternItem;
import appeng.recipes.handlers.GrinderRecipes;
import appeng.tile.misc.InscriberRecipes;
import appeng.util.Platform;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;

public class RestrictedInputSlot
extends AppEngSlot {
    private static final List<ResourceLocation> METAL_INGOT_TAGS = ImmutableList.of((Object)new ResourceLocation("forge:ingots/copper"), (Object)new ResourceLocation("forge:ingots/tin"), (Object)new ResourceLocation("forge:ingots/iron"), (Object)new ResourceLocation("forge:ingots/gold"), (Object)new ResourceLocation("forge:ingots/lead"), (Object)new ResourceLocation("forge:ingots/bronze"), (Object)new ResourceLocation("forge:ingots/brass"), (Object)new ResourceLocation("forge:ingots/nickel"), (Object)new ResourceLocation("forge:ingots/aluminium"));
    private final PlacableItemType which;
    private boolean allowEdit = true;
    private int stackLimit = -1;

    public RestrictedInputSlot(PlacableItemType valid, IItemHandler inv, int invSlot) {
        super(inv, invSlot);
        this.which = valid;
        this.setIcon(valid.icon);
    }

    @Override
    public int func_75219_a() {
        if (this.stackLimit != -1) {
            return this.stackLimit;
        }
        return super.func_75219_a();
    }

    public Slot setStackLimit(int i) {
        this.stackLimit = i;
        return this;
    }

    private World getWorld() {
        return this.getContainer().getPlayerInventory().field_70458_d.func_130014_f_();
    }

    @Override
    public boolean func_75214_a(ItemStack stack) {
        if (!this.getContainer().isValidForSlot(this, stack)) {
            return false;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_190931_a) {
            return false;
        }
        if (!super.func_75214_a(stack)) {
            return false;
        }
        if (!this.isAllowEdit()) {
            return false;
        }
        IDefinitions definitions = Api.instance().definitions();
        IMaterials materials = definitions.materials();
        IItems items = definitions.items();
        ICraftingHelper crafting = Api.instance().crafting();
        switch (this.which) {
            case ENCODED_CRAFTING_PATTERN: {
                ICraftingPatternDetails de = crafting.decodePattern(stack, this.getWorld());
                if (de != null) {
                    return de.isCraftable();
                }
                return false;
            }
            case VALID_ENCODED_PATTERN_W_OUTPUT: 
            case ENCODED_PATTERN_W_OUTPUT: 
            case ENCODED_PATTERN: {
                return crafting.isEncodedPattern(stack);
            }
            case BLANK_PATTERN: {
                return materials.blankPattern().isSameAs(stack);
            }
            case PATTERN: {
                return materials.blankPattern().isSameAs(stack) || crafting.isEncodedPattern(stack);
            }
            case INSCRIBER_PLATE: {
                if (materials.namePress().isSameAs(stack)) {
                    return true;
                }
                return InscriberRecipes.isValidOptionalIngredient(this.getWorld(), stack);
            }
            case INSCRIBER_INPUT: {
                return true;
            }
            case METAL_INGOTS: {
                return RestrictedInputSlot.isMetalIngot(stack);
            }
            case VIEW_CELL: {
                return items.viewCell().isSameAs(stack);
            }
            case ORE: {
                return GrinderRecipes.isValidIngredient(this.getWorld(), stack);
            }
            case FUEL: {
                return ForgeHooks.getBurnTime((ItemStack)stack) > 0;
            }
            case POWERED_TOOL: {
                return Platform.isChargeable(stack);
            }
            case QE_SINGULARITY: {
                return materials.qESingularity().isSameAs(stack);
            }
            case RANGE_BOOSTER: {
                return materials.wirelessBooster().isSameAs(stack);
            }
            case SPATIAL_STORAGE_CELLS: {
                return stack.func_77973_b() instanceof ISpatialStorageCell && ((ISpatialStorageCell)stack.func_77973_b()).isSpatialStorage(stack);
            }
            case STORAGE_CELLS: {
                return Api.instance().registries().cell().isCellHandled(stack);
            }
            case WORKBENCH_CELL: {
                return stack.func_77973_b() instanceof ICellWorkbenchItem && ((ICellWorkbenchItem)stack.func_77973_b()).isEditable(stack);
            }
            case STORAGE_COMPONENT: {
                return stack.func_77973_b() instanceof IStorageComponent && ((IStorageComponent)stack.func_77973_b()).isStorageComponent(stack);
            }
            case TRASH: {
                if (Api.instance().registries().cell().isCellHandled(stack)) {
                    return false;
                }
                return !(stack.func_77973_b() instanceof IStorageComponent) || !((IStorageComponent)stack.func_77973_b()).isStorageComponent(stack);
            }
            case ENCODABLE_ITEM: {
                return stack.func_77973_b() instanceof INetworkEncodable || Api.instance().registries().wireless().isWirelessTerminal(stack);
            }
            case BIOMETRIC_CARD: {
                return stack.func_77973_b() instanceof IBiometricCard;
            }
            case UPGRADES: {
                return stack.func_77973_b() instanceof IUpgradeModule && ((IUpgradeModule)stack.func_77973_b()).getType(stack) != null;
            }
        }
        return false;
    }

    @Override
    public boolean func_82869_a(PlayerEntity player) {
        return this.isAllowEdit();
    }

    @Override
    public ItemStack getDisplayStack() {
        EncodedPatternItem iep;
        ItemStack out;
        ItemStack is;
        if (this.isRemote() && this.which == PlacableItemType.ENCODED_PATTERN && !(is = super.getDisplayStack()).func_190926_b() && is.func_77973_b() instanceof EncodedPatternItem && !(out = (iep = (EncodedPatternItem)is.func_77973_b()).getOutput(is)).func_190926_b()) {
            return out;
        }
        return super.getDisplayStack();
    }

    public static boolean isMetalIngot(ItemStack i) {
        if (Platform.itemComparisons().isSameItem(i, new ItemStack((IItemProvider)Items.field_151042_j))) {
            return true;
        }
        Set itemTags = i.func_77973_b().getTags();
        for (ResourceLocation tagName : METAL_INGOT_TAGS) {
            if (!itemTags.contains(tagName)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowEdit() {
        return this.allowEdit;
    }

    public void setAllowEdit(boolean allowEdit) {
        this.allowEdit = allowEdit;
    }

    @Override
    protected boolean getCurrentValidationState() {
        if (this.which == PlacableItemType.VALID_ENCODED_PATTERN_W_OUTPUT) {
            ItemStack stack = this.func_75211_c();
            return stack.func_190926_b() || Api.instance().crafting().decodePattern(stack, this.getWorld()) != null;
        }
        return true;
    }

    public static enum PlacableItemType {
        STORAGE_CELLS(Icon.BACKGROUND_STORAGE_CELL),
        ORE(Icon.BACKGROUND_ORE),
        STORAGE_COMPONENT(Icon.BACKGROUND_STORAGE_COMPONENT),
        ENCODABLE_ITEM(Icon.BACKGROUND_WIRELESS_TERM),
        TRASH(Icon.BACKGROUND_TRASH),
        VALID_ENCODED_PATTERN_W_OUTPUT(Icon.BACKGROUND_ENCODED_PATTERN),
        ENCODED_PATTERN_W_OUTPUT(Icon.BACKGROUND_ENCODED_PATTERN),
        ENCODED_CRAFTING_PATTERN(Icon.BACKGROUND_ENCODED_PATTERN),
        ENCODED_PATTERN(Icon.BACKGROUND_ENCODED_PATTERN),
        PATTERN(Icon.BACKGROUND_BLANK_PATTERN),
        BLANK_PATTERN(Icon.BACKGROUND_BLANK_PATTERN),
        POWERED_TOOL(Icon.BACKGROUND_CHARGABLE),
        RANGE_BOOSTER(Icon.BACKGROUND_WIRELESS_BOOSTER),
        QE_SINGULARITY(Icon.BACKGROUND_SINGULARITY),
        SPATIAL_STORAGE_CELLS(Icon.BACKGROUND_SPATIAL_CELL),
        FUEL(Icon.BACKGROUND_FUEL),
        UPGRADES(Icon.BACKGROUND_UPGRADE),
        WORKBENCH_CELL(Icon.BACKGROUND_STORAGE_CELL),
        BIOMETRIC_CARD(Icon.BACKGROUND_BIOMETRIC_CARD),
        VIEW_CELL(Icon.BACKGROUND_VIEW_CELL),
        INSCRIBER_PLATE(Icon.BACKGROUND_PLATE),
        INSCRIBER_INPUT(Icon.BACKGROUND_INGOT),
        METAL_INGOTS(Icon.BACKGROUND_INGOT);

        public final Icon icon;

        private PlacableItemType(Icon o) {
            this.icon = o;
        }
    }
}

