/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync;

import appeng.api.features.AEFeature;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.sync.BasePacketHandler;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.network.NetworkHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BasePacket {
    public static final int MAX_STRING_LENGTH = Short.MAX_VALUE;
    private PacketBuffer p;

    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        throw new UnsupportedOperationException("This packet ( " + this.getPacketID() + " does not implement a server side handler.");
    }

    public final int getPacketID() {
        return BasePacketHandler.PacketTypes.getID(this.getClass()).ordinal();
    }

    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        throw new UnsupportedOperationException("This packet ( " + this.getPacketID() + " does not implement a client side handler.");
    }

    protected void configureWrite(PacketBuffer data) {
        data.capacity(data.readableBytes());
        this.p = data;
    }

    public IPacket<?> toPacket(NetworkDirection direction) {
        if (this.p.array().length > 0x200000) {
            throw new IllegalArgumentException("Sorry AE2 made a " + this.p.array().length + " byte packet by accident!");
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.PACKET_LOGGING)) {
            AELog.info(this.getClass().getName() + " : " + this.p.readableBytes(), new Object[0]);
        }
        return direction.buildPacket(Pair.of((Object)this.p, (Object)0), NetworkHandler.instance().getChannel()).getThis();
    }
}

