/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.DimensionalCoord;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.CompassResponsePacket;
import appeng.core.worlddata.WorldData;
import appeng.services.compass.ICompassCallback;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;

public class CompassRequestPacket
extends BasePacket
implements ICompassCallback {
    final long attunement;
    final int cx;
    final int cz;
    final int cdy;
    private PlayerEntity talkBackTo;

    public CompassRequestPacket(PacketBuffer stream) {
        this.attunement = stream.readLong();
        this.cx = stream.readInt();
        this.cz = stream.readInt();
        this.cdy = stream.readInt();
    }

    public CompassRequestPacket(long attunement, int cx, int cz, int cdy) {
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        this.attunement = attunement;
        data.writeLong(this.attunement);
        this.cx = cx;
        data.writeInt(this.cx);
        this.cz = cz;
        data.writeInt(this.cz);
        this.cdy = cdy;
        data.writeInt(this.cdy);
        this.configureWrite(data);
    }

    @Override
    public void calculatedDirection(boolean hasResult, boolean spin, double radians, double dist) {
        NetworkHandler.instance().sendTo(new CompassResponsePacket(this, hasResult, spin, radians), (ServerPlayerEntity)this.talkBackTo);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        this.talkBackTo = player;
        DimensionalCoord loc = new DimensionalCoord(player.field_70170_p, this.cx << 4, this.cdy << 5, this.cz << 4);
        WorldData.instance().compassData().service().getCompassDirection(loc, 174, this);
    }
}

