/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.tile.AEBaseTileEntity;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemGenTileEntity
extends AEBaseTileEntity {
    private static final Queue<ItemStack> SHARED_POSSIBLE_ITEMS = new ArrayDeque<ItemStack>();
    private final IItemHandler handler = new QueuedItemHandler();
    private Item filter = Items.field_190931_a;
    private final Queue<ItemStack> possibleItems = new ArrayDeque<ItemStack>();

    public ItemGenTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        if (SHARED_POSSIBLE_ITEMS.isEmpty()) {
            for (Item item : ForgeRegistries.ITEMS) {
                ItemGenTileEntity.addPossibleItem(item, SHARED_POSSIBLE_ITEMS);
            }
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        data.func_74778_a("filter", this.filter.getRegistryName().toString());
        return super.func_189515_b(data);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT data) {
        if (data.func_74764_b("filter")) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(data.func_74779_i("filter")));
            this.setItem(item);
        }
        super.func_230337_a_(blockState, data);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == capability) {
            return LazyOptional.of(() -> this.handler);
        }
        return super.getCapability(capability, facing);
    }

    public void setItem(Item item) {
        this.filter = item;
        this.possibleItems.clear();
        ItemGenTileEntity.addPossibleItem(this.filter, this.possibleItems);
    }

    private Queue<ItemStack> getPossibleItems() {
        return this.filter != Items.field_190931_a ? this.possibleItems : SHARED_POSSIBLE_ITEMS;
    }

    private static void addPossibleItem(Item item, Queue<ItemStack> queue) {
        if (item == null || item == Items.field_190931_a) {
            return;
        }
        if (item.func_77645_m()) {
            ItemStack sampleStack = new ItemStack((IItemProvider)item);
            int maxDamage = sampleStack.func_77958_k();
            for (int dmg = 0; dmg < maxDamage; ++dmg) {
                ItemStack is = sampleStack.func_77946_l();
                is.func_196085_b(dmg);
                queue.add(is);
            }
        } else if (item.func_77640_w() != null) {
            NonNullList list = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), list);
            queue.addAll((Collection<ItemStack>)list);
        }
    }

    class QueuedItemHandler
    implements IItemHandler {
        QueuedItemHandler() {
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemGenTileEntity.this.getPossibleItems().peek() != null ? ((ItemStack)ItemGenTileEntity.this.getPossibleItems().peek()).func_77946_l() : ItemStack.field_190927_a;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }

        public int getSlots() {
            return 1;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack is = (ItemStack)ItemGenTileEntity.this.getPossibleItems().peek();
            if (is == null) {
                return ItemStack.field_190927_a;
            }
            return simulate ? is.func_77946_l() : this.getNextItem();
        }

        private ItemStack getNextItem() {
            ItemStack is = (ItemStack)ItemGenTileEntity.this.getPossibleItems().poll();
            ItemGenTileEntity.this.getPossibleItems().add(is);
            return is.func_77946_l();
        }
    }
}

