/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IStorageComponent;
import appeng.client.gui.Icon;
import appeng.core.Api;
import appeng.integration.modules.jei.IconDrawable;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

class CondenserCategory
implements IRecipeCategory<CondenserOutput> {
    public static final ResourceLocation UID = new ResourceLocation("appliedenergistics2", "condenser");
    private final String localizedName = I18n.func_135052_a((String)"gui.appliedenergistics2.Condenser", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable iconTrash;
    private final IDrawableAnimated progress;
    private final IDrawable iconButton;
    private final IDrawable icon;
    private final Map<CondenserOutput, IDrawable> buttonIcons;

    public CondenserCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)Api.INSTANCE.definitions().blocks().condenser().stack(1));
        ResourceLocation location = new ResourceLocation("appliedenergistics2", "textures/guis/condenser.png");
        this.background = guiHelper.createDrawable(location, 50, 25, 94, 48);
        this.iconTrash = new IconDrawable(Icon.BACKGROUND_TRASH, 1, 27);
        this.iconButton = new IconDrawable(Icon.TOOLBAR_BUTTON_BACKGROUND, 78, 26);
        IDrawableStatic progressDrawable = guiHelper.drawableBuilder(location, 178, 25, 6, 18).addPadding(0, 0, 70, 0).build();
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, 40, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.buttonIcons = new EnumMap<CondenserOutput, IDrawable>(CondenserOutput.class);
        this.buttonIcons.put(CondenserOutput.MATTER_BALLS, new IconDrawable(Icon.CONDENSER_OUTPUT_MATTER_BALL, 78, 26));
        this.buttonIcons.put(CondenserOutput.SINGULARITY, new IconDrawable(Icon.CONDENSER_OUTPUT_SINGULARITY, 78, 26));
    }

    private ItemStack getOutput(CondenserOutput recipe) {
        switch (recipe) {
            case MATTER_BALLS: {
                return Api.INSTANCE.definitions().materials().matterBall().stack(1);
            }
            case SINGULARITY: {
                return Api.INSTANCE.definitions().materials().singularity().stack(1);
            }
        }
        return ItemStack.field_190927_a;
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CondenserOutput> getRecipeClass() {
        return CondenserOutput.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CondenserOutput recipe, IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.getOutput(recipe));
    }

    public void draw(CondenserOutput recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.progress.draw(matrixStack);
        this.iconTrash.draw(matrixStack);
        this.iconButton.draw(matrixStack);
        IDrawable buttonIcon = this.buttonIcons.get((Object)recipe);
        if (buttonIcon != null) {
            buttonIcon.draw(matrixStack);
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, CondenserOutput output, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, false, 54, 26);
        itemStacks.init(1, true, 50, 0);
        itemStacks.set(1, this.getViableStorageComponents(output));
        itemStacks.set(ingredients);
    }

    private List<ItemStack> getViableStorageComponents(CondenserOutput condenserOutput) {
        IMaterials materials = Api.instance().definitions().materials();
        ArrayList<ItemStack> viableComponents = new ArrayList<ItemStack>();
        materials.cell1kPart().maybeStack(1).ifPresent(itemStack -> this.addViableComponent(condenserOutput, (List<ItemStack>)viableComponents, (ItemStack)itemStack));
        materials.cell4kPart().maybeStack(1).ifPresent(itemStack -> this.addViableComponent(condenserOutput, (List<ItemStack>)viableComponents, (ItemStack)itemStack));
        materials.cell16kPart().maybeStack(1).ifPresent(itemStack -> this.addViableComponent(condenserOutput, (List<ItemStack>)viableComponents, (ItemStack)itemStack));
        materials.cell64kPart().maybeStack(1).ifPresent(itemStack -> this.addViableComponent(condenserOutput, (List<ItemStack>)viableComponents, (ItemStack)itemStack));
        return viableComponents;
    }

    private void addViableComponent(CondenserOutput condenserOutput, List<ItemStack> viableComponents, ItemStack itemStack) {
        IStorageComponent comp = (IStorageComponent)itemStack.func_77973_b();
        int storage = comp.getBytes(itemStack) * 8;
        if (storage >= condenserOutput.requiredPower) {
            viableComponents.add(itemStack);
        }
    }

    public List<ITextComponent> getTooltipStrings(CondenserOutput output, double mouseX, double mouseY) {
        if (mouseX >= 28.0 && mouseX < 44.0 && mouseY >= 78.0 && mouseY < 94.0) {
            String key;
            switch (output) {
                case MATTER_BALLS: {
                    key = "gui.tooltips.appliedenergistics2.MatterBalls";
                    break;
                }
                case SINGULARITY: {
                    key = "gui.tooltips.appliedenergistics2.Singularity";
                    break;
                }
                default: {
                    return Collections.emptyList();
                }
            }
            return Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent(key)});
        }
        return Collections.emptyList();
    }
}

