/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.Api;
import appeng.items.materials.MaterialType;
import appeng.items.storage.AbstractStorageCell;
import appeng.util.InventoryAdaptor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class BasicStorageCellItem
extends AbstractStorageCell<IAEItemStack> {
    protected final int perType;
    protected final double idleDrain;

    public BasicStorageCellItem(Item.Properties props, MaterialType whichCell, int kilobytes) {
        super(props, whichCell, kilobytes);
        switch (whichCell) {
            case ITEM_1K_CELL_COMPONENT: {
                this.idleDrain = 0.5;
                this.perType = 8;
                break;
            }
            case ITEM_4K_CELL_COMPONENT: {
                this.idleDrain = 1.0;
                this.perType = 32;
                break;
            }
            case ITEM_16K_CELL_COMPONENT: {
                this.idleDrain = 1.5;
                this.perType = 128;
                break;
            }
            case ITEM_64K_CELL_COMPONENT: {
                this.idleDrain = 2.0;
                this.perType = 512;
                break;
            }
            default: {
                this.idleDrain = 0.0;
                this.perType = 8;
            }
        }
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return this.perType;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    protected void dropEmptyStorageCellCase(InventoryAdaptor ia, PlayerEntity player) {
        Api.instance().definitions().materials().emptyStorageCell().maybeStack(1).ifPresent(is -> {
            ItemStack extraA = ia.addItems((ItemStack)is);
            if (!extraA.func_190926_b()) {
                player.func_71019_a(extraA, false);
            }
        });
    }
}

