/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.me.cluster.IAECluster;
import appeng.me.cluster.MBCalculator;
import appeng.tile.spatial.SpatialPylonTileEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpatialPylonCluster
implements IAECluster {
    private final World world;
    private final BlockPos boundsMin;
    private final BlockPos boundsMax;
    private final List<SpatialPylonTileEntity> line = new ArrayList<SpatialPylonTileEntity>();
    private boolean isDestroyed = false;
    private Axis currentAxis = Axis.UNFORMED;
    private boolean isValid;

    public SpatialPylonCluster(World world, BlockPos boundsMin, BlockPos boundsMax) {
        this.world = world;
        this.boundsMin = boundsMin.func_185334_h();
        this.boundsMax = boundsMax.func_185334_h();
        if (this.getBoundsMin().func_177958_n() != this.getBoundsMax().func_177958_n()) {
            this.setCurrentAxis(Axis.X);
        } else if (this.getBoundsMin().func_177956_o() != this.getBoundsMax().func_177956_o()) {
            this.setCurrentAxis(Axis.Y);
        } else if (this.getBoundsMin().func_177952_p() != this.getBoundsMax().func_177952_p()) {
            this.setCurrentAxis(Axis.Z);
        } else {
            this.setCurrentAxis(Axis.UNFORMED);
        }
    }

    @Override
    public void updateStatus(boolean updateGrid) {
        for (SpatialPylonTileEntity r : this.getLine()) {
            r.recalculateDisplay();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    @Override
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        MBCalculator.setModificationInProgress(this);
        try {
            for (SpatialPylonTileEntity r : this.getLine()) {
                r.updateStatus(null);
            }
        }
        finally {
            MBCalculator.setModificationInProgress(null);
        }
    }

    public Iterator<SpatialPylonTileEntity> getTiles() {
        return this.getLine().iterator();
    }

    public int tileCount() {
        return this.getLine().size();
    }

    public Axis getCurrentAxis() {
        return this.currentAxis;
    }

    private void setCurrentAxis(Axis currentAxis) {
        this.currentAxis = currentAxis;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public BlockPos getBoundsMax() {
        return this.boundsMax;
    }

    @Override
    public BlockPos getBoundsMin() {
        return this.boundsMin;
    }

    List<SpatialPylonTileEntity> getLine() {
        return this.line;
    }

    public static enum Axis {
        X,
        Y,
        Z,
        UNFORMED;

    }
}

