/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.pathfinding;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridVisitor;
import appeng.tile.networking.ControllerTileEntity;
import net.minecraft.util.math.BlockPos;

public class ControllerValidator
implements IGridVisitor {
    private boolean isValid = true;
    private int found = 0;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    public ControllerValidator(int x, int y, int z) {
        this.minX = x;
        this.maxX = x;
        this.minY = y;
        this.maxY = y;
        this.minZ = z;
        this.maxZ = z;
    }

    @Override
    public boolean visitNode(IGridNode n) {
        IGridHost host = n.getMachine();
        if (this.isValid() && host instanceof ControllerTileEntity) {
            ControllerTileEntity c = (ControllerTileEntity)host;
            BlockPos pos = c.func_174877_v();
            this.minX = Math.min(pos.func_177958_n(), this.minX);
            this.maxX = Math.max(pos.func_177958_n(), this.maxX);
            this.minY = Math.min(pos.func_177956_o(), this.minY);
            this.maxY = Math.max(pos.func_177956_o(), this.maxY);
            this.minZ = Math.min(pos.func_177952_p(), this.minZ);
            this.maxZ = Math.max(pos.func_177952_p(), this.maxZ);
            if (this.maxX - this.minX < 7 && this.maxY - this.minY < 7 && this.maxZ - this.minZ < 7) {
                this.setFound(this.getFound() + 1);
                return true;
            }
        } else {
            return false;
        }
        this.setValid(false);
        return this.isValid();
    }

    public boolean isValid() {
        return this.isValid;
    }

    private void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public int getFound() {
        return this.found;
    }

    private void setFound(int found) {
        this.found = found;
    }
}

