/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.events.LocatableEventAnnounce;
import appeng.api.features.ILocatable;
import appeng.api.features.IPlayerRegistry;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkSecurityChange;
import appeng.api.networking.security.ISecurityProvider;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.Api;
import appeng.helpers.PlayerSecurityWrapper;
import appeng.me.GridAccessException;
import appeng.me.helpers.MEMonitorHandler;
import appeng.me.storage.SecurityStationInventory;
import appeng.tile.grid.AENetworkTileEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;

public class SecurityStationTileEntity
extends AENetworkTileEntity
implements ITerminalHost,
IAEAppEngInventory,
ILocatable,
IConfigManagerHost,
ISecurityProvider,
IColorableTile {
    private static int difference = 0;
    private final AppEngInternalInventory configSlot = new AppEngInternalInventory(this, 1);
    private final IConfigManager cm = new ConfigManager(this);
    private final SecurityStationInventory inventory = new SecurityStationInventory(this);
    private final MEMonitorHandler<IAEItemStack> securityMonitor = new MEMonitorHandler<IAEItemStack>(this.inventory);
    private long securityKey;
    private AEColor paintedColor = AEColor.TRANSPARENT;
    private boolean isActive = false;

    public SecurityStationTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.getProxy().setIdlePowerUsage(2.0);
        this.securityKey = System.currentTimeMillis() * 10L + (long)(++difference);
        if (difference > 10) {
            difference = 0;
        }
        this.cm.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.cm.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.cm.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        if (!ItemHandlerUtil.isEmpty((IItemHandler)this.getConfigSlot())) {
            drops.add(this.getConfigSlot().getStackInSlot(0));
        }
        for (IAEItemStack ais : this.inventory.getStoredItems()) {
            drops.add(ais.createItemStack());
        }
    }

    IMEInventoryHandler<IAEItemStack> getSecurityInventory() {
        return this.inventory;
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean wasActive = this.isActive;
        this.isActive = data.readBoolean();
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        return oldPaintedColor != this.paintedColor || wasActive != this.isActive || c;
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.getProxy().isActive());
        data.writeByte(this.paintedColor.ordinal());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        this.cm.writeToNBT(data);
        data.func_74774_a("paintedColor", (byte)this.paintedColor.ordinal());
        data.func_74772_a("securityKey", this.securityKey);
        this.getConfigSlot().writeToNBT(data, "config");
        CompoundNBT storedItems = new CompoundNBT();
        int offset = 0;
        for (IAEItemStack ais : this.inventory.getStoredItems()) {
            CompoundNBT it = new CompoundNBT();
            ais.createItemStack().func_77955_b(it);
            storedItems.func_218657_a(String.valueOf(offset), (INBT)it);
            ++offset;
        }
        data.func_218657_a("storedItems", (INBT)storedItems);
        return data;
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT data) {
        super.func_230337_a_(blockState, data);
        this.cm.readFromNBT(data);
        if (data.func_74764_b("paintedColor")) {
            this.paintedColor = AEColor.values()[data.func_74771_c("paintedColor")];
        }
        this.securityKey = data.func_74763_f("securityKey");
        this.getConfigSlot().readFromNBT(data, "config");
        CompoundNBT storedItems = data.func_74775_l("storedItems");
        for (Object key : storedItems.func_150296_c()) {
            INBT obj = storedItems.func_74781_a((String)key);
            if (!(obj instanceof CompoundNBT)) continue;
            this.inventory.getStoredItems().add(AEItemStack.fromItemStack(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)obj))));
        }
    }

    public void inventoryChanged() {
        try {
            this.saveChanges();
            this.getProxy().getGrid().postEvent(new MENetworkSecurityChange());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @MENetworkEventSubscribe
    public void bootUpdate(MENetworkChannelsChanged changed) {
        this.markForUpdate();
    }

    @MENetworkEventSubscribe
    public void powerUpdate(MENetworkPowerStatusChange changed) {
        this.markForUpdate();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        MinecraftForge.EVENT_BUS.post((Event)new LocatableEventAnnounce(this, LocatableEventAnnounce.LocatableEvent.UNREGISTER));
        this.isActive = false;
    }

    @Override
    public void onReady() {
        super.onReady();
        if (!this.isRemote()) {
            this.isActive = true;
            MinecraftForge.EVENT_BUS.post((Event)new LocatableEventAnnounce(this, LocatableEventAnnounce.LocatableEvent.REGISTER));
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        MinecraftForge.EVENT_BUS.post((Event)new LocatableEventAnnounce(this, LocatableEventAnnounce.LocatableEvent.UNREGISTER));
        this.isActive = false;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    public boolean isActive() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            return this.isPowered();
        }
        return this.isActive;
    }

    @Override
    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        if (channel == Api.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            return this.securityMonitor;
        }
        return null;
    }

    @Override
    public long getLocatableSerial() {
        return this.securityKey;
    }

    public boolean isPowered() {
        return this.getProxy().isActive();
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
    }

    @Override
    public long getSecurityKey() {
        return this.securityKey;
    }

    @Override
    public void readPermissions(Map<Integer, EnumSet<SecurityPermissions>> playerPerms) {
        IPlayerRegistry pr = Api.instance().registries().players();
        for (IAEItemStack ais : this.inventory.getStoredItems()) {
            ItemStack is = ais.createItemStack();
            Item i = is.func_77973_b();
            if (!(i instanceof IBiometricCard)) continue;
            IBiometricCard bc = (IBiometricCard)i;
            bc.registerPermissions(new PlayerSecurityWrapper(playerPerms), pr, is);
        }
        playerPerms.put(this.getProxy().getNode().getPlayerID(), EnumSet.allOf(SecurityPermissions.class));
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.isActive && this.getProxy().isActive();
    }

    @Override
    public int getOwner() {
        return this.getProxy().getNode().getPlayerID();
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(Direction side, AEColor newPaintedColor, PlayerEntity who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    public AppEngInternalInventory getConfigSlot() {
        return this.configSlot;
    }
}

