/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AESharedItemStack;
import appeng.util.item.ItemVariantList;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.item.ItemStack;

class FuzzyItemVariantList
extends ItemVariantList {
    static final SharedStackComparator COMPARATOR = new SharedStackComparator();
    private final Object2ObjectSortedMap<Object, IAEItemStack> records = new Object2ObjectAVLTreeMap((Comparator)COMPARATOR);
    private static final int MIN_DAMAGE_VALUE = -1;

    FuzzyItemVariantList() {
    }

    @Override
    public Collection<IAEItemStack> findFuzzy(IAEItemStack filter, FuzzyMode fuzzy) {
        ItemStack itemStack = filter.getDefinition();
        ItemDamageBound lowerBound = FuzzyItemVariantList.makeLowerBound(itemStack, fuzzy);
        ItemDamageBound upperBound = FuzzyItemVariantList.makeUpperBound(itemStack, fuzzy);
        Preconditions.checkState((lowerBound.itemDamage > upperBound.itemDamage ? 1 : 0) != 0);
        return this.records.subMap((Object)lowerBound, (Object)upperBound).values();
    }

    @Override
    Map<AESharedItemStack, IAEItemStack> getRecords() {
        return (Map)this.records;
    }

    static ItemDamageBound makeLowerBound(ItemStack stack, FuzzyMode fuzzy) {
        int damage;
        Preconditions.checkState((boolean)stack.func_77973_b().func_77645_m(), (Object)"Item#isDamageable() has to be true");
        if (fuzzy == FuzzyMode.IGNORE_ALL) {
            damage = stack.func_77958_k();
        } else {
            int breakpoint = fuzzy.calculateBreakPoint(stack.func_77958_k());
            damage = stack.func_77952_i() <= breakpoint ? breakpoint : stack.func_77958_k();
        }
        return new ItemDamageBound(damage);
    }

    static ItemDamageBound makeUpperBound(ItemStack stack, FuzzyMode fuzzy) {
        int damage;
        Preconditions.checkState((boolean)stack.func_77973_b().func_77645_m(), (Object)"Item#isDamageable() has to be true");
        if (fuzzy == FuzzyMode.IGNORE_ALL) {
            damage = -1;
        } else {
            int breakpoint = fuzzy.calculateBreakPoint(stack.func_77958_k());
            damage = stack.func_77952_i() <= breakpoint ? -1 : breakpoint;
        }
        return new ItemDamageBound(damage);
    }

    static class SharedStackComparator
    implements Comparator<Object> {
        SharedStackComparator() {
        }

        @Override
        public int compare(Object a, Object b) {
            int itemDamageB;
            int itemDamageA;
            ItemDamageBound boundA = null;
            AESharedItemStack stackA = null;
            if (a instanceof ItemDamageBound) {
                boundA = (ItemDamageBound)a;
                itemDamageA = boundA.itemDamage;
            } else {
                stackA = (AESharedItemStack)a;
                itemDamageA = stackA.getItemDamage();
            }
            ItemDamageBound boundB = null;
            AESharedItemStack stackB = null;
            if (b instanceof ItemDamageBound) {
                boundB = (ItemDamageBound)b;
                itemDamageB = boundB.itemDamage;
            } else {
                stackB = (AESharedItemStack)b;
                itemDamageB = stackB.getItemDamage();
            }
            if (boundA != null || boundB != null) {
                return Integer.compare(itemDamageB, itemDamageA);
            }
            ItemStack itemStackA = stackA.getDefinition();
            ItemStack itemStackB = stackB.getDefinition();
            Preconditions.checkState((itemStackA.func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
            Preconditions.checkArgument((itemStackB.func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
            if (itemStackA == itemStackB) {
                return 0;
            }
            int damageValue = Integer.compare(itemDamageB, itemDamageA);
            if (damageValue != 0) {
                return damageValue;
            }
            return Long.compare(System.identityHashCode(itemStackA), System.identityHashCode(itemStackB));
        }
    }

    static class ItemDamageBound {
        final int itemDamage;

        public ItemDamageBound(int itemDamage) {
            this.itemDamage = itemDamage;
        }
    }
}

