/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.api.prefab.item;

import javax.annotation.Nullable;
import li.cil.manual.api.ManualModel;
import li.cil.manual.api.ManualScreenStyle;
import li.cil.manual.api.ManualStyle;
import li.cil.manual.api.util.ShowManualScreenEvent;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class AbstractManualItem
extends Item {
    protected AbstractManualItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.func_201670_d()) {
            this.openManualFor(context, world);
        }
        return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.func_201670_d()) {
            this.openManual(player);
        }
        return ActionResult.func_233538_a_((Object)player.func_184586_b(hand), (boolean)world.func_201670_d());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract ManualModel getManualModel();

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected ManualStyle getManualStyle() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected ManualScreenStyle getScreenStyle() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showManualScreen() {
        MinecraftForge.EVENT_BUS.post((Event)new ShowManualScreenEvent(this.getManualModel(), this.getManualStyle(), this.getScreenStyle()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openManualFor(ItemUseContext context, World world) {
        ManualModel model = this.getManualModel();
        model.reset();
        model.pathFor(world, context.func_195995_a(), context.func_196000_l()).ifPresent(model::push);
        this.showManualScreen();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openManual(PlayerEntity player) {
        ManualModel manual = this.getManualModel();
        if (player.func_225608_bj_()) {
            manual.reset();
        }
        this.showManualScreen();
    }
}

