/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.api.prefab.provider;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Optional;
import li.cil.manual.api.content.Document;
import li.cil.manual.api.provider.DocumentProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;

@OnlyIn(value=Dist.CLIENT)
public class NamespaceDocumentProvider
extends ForgeRegistryEntry<DocumentProvider>
implements DocumentProvider {
    private final String namespace;
    private final String basePath;

    public NamespaceDocumentProvider(String namespace, String basePath) {
        this.namespace = namespace;
        this.basePath = basePath.endsWith("/") ? basePath : basePath + "/";
    }

    public NamespaceDocumentProvider(String namespace) {
        this(namespace, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Document> getDocument(String path, String language) {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        ResourceLocation location = new ResourceLocation(this.namespace, this.basePath + path);
        try (InputStream stream = resourceManager.func_199002_a(location).func_199027_b();){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            Optional<Document> optional = Optional.of(new Document(lines, location));
            return optional;
        }
        catch (Throwable ignored) {
            return Optional.empty();
        }
    }
}

