/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.api.prefab.provider;

import java.util.Optional;
import li.cil.manual.api.provider.PathProvider;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;

@OnlyIn(value=Dist.CLIENT)
public class NamespacePathProvider
extends ForgeRegistryEntry<PathProvider>
implements PathProvider {
    private static final String NAMESPACE = "%NAMESPACE%";
    private static final String PATH = "%PATH%";
    private static final String BLOCK_PATH_WITH_NAMESPACE = "%LANGUAGE%/%NAMESPACE%/block/%PATH%.md";
    private static final String BLOCK_PATH = "%LANGUAGE%/block/%PATH%.md";
    private static final String ITEM_PATH_WITH_NAMESPACE = "%LANGUAGE%/%NAMESPACE%/item/%PATH%.md";
    private static final String ITEM_PATH = "%LANGUAGE%/item/%PATH%.md";
    private final String namespace;
    private final boolean keepNamespaceInPath;

    public NamespacePathProvider(String namespace) {
        this(namespace, false);
    }

    public NamespacePathProvider(String namespace, boolean keepNamespaceInPath) {
        this.namespace = namespace;
        this.keepNamespaceInPath = keepNamespaceInPath;
    }

    @Override
    public Optional<String> pathFor(ItemStack stack) {
        if (stack.func_190926_b()) {
            return Optional.empty();
        }
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (block != Blocks.field_150350_a) {
            ResourceLocation blockId = block.getRegistryName();
            if (blockId == null) {
                return Optional.empty();
            }
            String blockNamespace = blockId.func_110624_b();
            if (this.namespace.equals(blockNamespace)) {
                String template = this.keepNamespaceInPath ? BLOCK_PATH_WITH_NAMESPACE : BLOCK_PATH;
                return Optional.of(template.replace(NAMESPACE, this.namespace).replace(PATH, blockId.func_110623_a()));
            }
        } else {
            ResourceLocation itemId = item.getRegistryName();
            if (itemId == null) {
                return Optional.empty();
            }
            String itemNamespace = itemId.func_110624_b();
            if (this.namespace.equals(itemNamespace)) {
                String template = this.keepNamespaceInPath ? ITEM_PATH_WITH_NAMESPACE : ITEM_PATH;
                return Optional.of(template.replace(NAMESPACE, this.namespace).replace(PATH, itemId.func_110623_a()));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> pathFor(World world, BlockPos pos, Direction face) {
        Block block = world.func_180495_p(pos).func_177230_c();
        ResourceLocation blockId = block.getRegistryName();
        if (blockId == null) {
            return Optional.empty();
        }
        String blockNamespace = blockId.func_110624_b();
        if (this.namespace.equals(blockNamespace)) {
            String template = this.keepNamespaceInPath ? BLOCK_PATH_WITH_NAMESPACE : BLOCK_PATH;
            return Optional.of(template.replace(NAMESPACE, this.namespace).replace(PATH, blockId.func_110623_a()));
        }
        return Optional.empty();
    }
}

