/*
 * Decompiled with CFR 0.152.
 */
package li.cil.manual.api.prefab.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.chars.Char2IntMap;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import java.util.Optional;
import li.cil.manual.api.render.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BitmapFontRenderer
implements FontRenderer {
    private final Char2IntMap CHAR_MAP;
    private final int COLUMNS = this.getResolution() / (this.charWidth() + this.getGapU());
    private final float U_SIZE = (float)this.charWidth() / (float)this.getResolution();
    private final float V_SIZE = (float)this.lineHeight() / (float)this.getResolution();
    private final float U_STEP = (float)(this.charWidth() + this.getGapU()) / (float)this.getResolution();
    private final float V_STEP = (float)(this.lineHeight() + this.getGapV()) / (float)this.getResolution();
    private RenderType renderLayer;

    protected BitmapFontRenderer() {
        this.CHAR_MAP = new Char2IntOpenHashMap();
        CharSequence chars = this.getCharacters();
        for (int index = 0; index < chars.length(); ++index) {
            this.CHAR_MAP.put(chars.charAt(index), index);
        }
    }

    @Override
    public void drawBatch(MatrixStack matrixStack, IRenderTypeBuffer bufferFactory, CharSequence value, int argb) {
        IVertexBuilder buffer = this.getDefaultBuffer(bufferFactory);
        float tx = 0.0f;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            this.drawChar(matrixStack, buffer, argb, tx, ch);
            tx += (float)(this.width(" ") + this.getGapU());
        }
    }

    @Override
    public int width(CharSequence value) {
        return value.length() * this.charWidth();
    }

    @Override
    public int width(ITextComponent value) {
        MutableInteger count = new MutableInteger();
        value.func_230438_a_(s -> {
            count.value += s.length() * this.charWidth();
            return Optional.empty();
        });
        return count.value;
    }

    protected abstract CharSequence getCharacters();

    protected abstract ResourceLocation getTextureLocation();

    protected abstract int getResolution();

    protected abstract int getGapU();

    protected abstract int getGapV();

    protected abstract int charWidth();

    private IVertexBuilder getDefaultBuffer(IRenderTypeBuffer bufferFactory) {
        if (this.renderLayer == null) {
            this.renderLayer = FontRenderTypes.create(this.getTextureLocation());
        }
        return bufferFactory.getBuffer(this.renderLayer);
    }

    private void drawChar(MatrixStack matrixStack, IVertexBuilder buffer, int argb, float x, char ch) {
        if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
            return;
        }
        int index = this.getCharIndex(ch);
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        int column = index % this.COLUMNS;
        int row = index / this.COLUMNS;
        float u = (float)column * this.U_STEP;
        float v = (float)row * this.V_STEP;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(matrix, x, (float)this.lineHeight(), 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(u, v + this.V_SIZE).func_181675_d();
        buffer.func_227888_a_(matrix, x + (float)this.charWidth(), (float)this.lineHeight(), 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(u + this.U_SIZE, v + this.V_SIZE).func_181675_d();
        buffer.func_227888_a_(matrix, x + (float)this.charWidth(), 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(u + this.U_SIZE, v).func_181675_d();
        buffer.func_227888_a_(matrix, x, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_181675_d();
    }

    private int getCharIndex(char ch) {
        if (!this.CHAR_MAP.containsKey(ch)) {
            return this.CHAR_MAP.get('?');
        }
        return this.CHAR_MAP.get(ch);
    }

    private static final class FontRenderTypes
    extends RenderType {
        public static RenderType create(ResourceLocation texture) {
            return FontRenderTypes.func_228633_a_((String)"markdown_manual/bitmap_font", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(field_228515_g_).func_228716_a_(field_228533_y_).func_228713_a_(field_228517_i_).func_228719_a_(field_228529_u_).func_228721_a_(field_239236_S_).func_228727_a_(field_228496_F_).func_228728_a_(false));
        }

        private FontRenderTypes() {
            super("", DefaultVertexFormats.field_181705_e, 0, 256, false, false, () -> {}, () -> {});
            throw new UnsupportedOperationException("No meant to be instantiated.");
        }
    }

    private static final class MutableInteger {
        public int value;

        private MutableInteger() {
        }
    }
}

